/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.swt;

import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.Algorithm;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.EvaluationPCA;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IAnalysisSettings;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.ISamplesPCA;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.Activator;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.runnable.CalculationExecutor;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.preferences.PreferencePage;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.preferences.PreferencePageLoadingPlot;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.preferences.PreferencePageScorePlot;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.swt.FilterSettingsUI;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.swt.PreprocessingSettingsUI;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.swt.SamplesListUI;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.statistics.ISample;
import org.eclipse.chemclipse.model.statistics.IVariable;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractLabelProvider;
import org.eclipse.chemclipse.swt.ui.components.ISearchListener;
import org.eclipse.chemclipse.swt.ui.components.SearchSupportUI;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;

public class AnalysisEditorUI
extends Composite {
    private static final Logger logger = Logger.getLogger(AnalysisEditorUI.class);
    private ISamplesPCA<? extends IVariable, ? extends ISample> samples = null;
    private EvaluationPCA evaluationPCA = null;
    private Composite toolbarSearch;
    private Spinner spinnerPCs;
    private ComboViewer comboViewerAlgorithm;
    private SamplesListUI sampleListUI;
    private PreprocessingSettingsUI preprocessingSettingsUI;
    private FilterSettingsUI filterSettingsUI;
    private Algorithm[] algorithms = Algorithm.getAlgorithms();

    public AnalysisEditorUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public boolean setFocus() {
        this.fireUpdate(this.getDisplay(), this.evaluationPCA);
        return super.setFocus();
    }

    public void setInput(ISamplesPCA<IVariable, ISample> samples) {
        this.samples = samples;
        if (samples != null) {
            this.sampleListUI.setInput(samples.getSampleList());
            this.updateWidgets(samples.getAnalysisSettings());
        } else {
            this.sampleListUI.setInput(null);
            this.updateWidgets(null);
        }
    }

    private void createControl() {
        this.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(this);
        this.toolbarSearch = this.createToolbarSearch(this);
        this.createDataTab(this);
        PartSupport.setCompositeVisibility((Composite)this.toolbarSearch, (boolean)false);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(7, false));
        this.createButtonToggleToolbarSearch(composite);
        this.createLabel(composite, "Number of PCs:");
        this.spinnerPCs = this.createSpinnerPrincipleComponents(composite);
        this.createLabel(composite, "Algorithm:");
        this.comboViewerAlgorithm = this.createComboViewerAlgorithm(composite);
        this.createButtonRun(composite);
        this.createSettingsButton(composite);
    }

    private Button createButtonToggleToolbarSearch(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle search toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)AnalysisEditorUI.this.toolbarSearch);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    private Spinner createSpinnerPrincipleComponents(Composite parent) {
        final Spinner spinner = new Spinner(parent, 2048);
        spinner.setToolTipText("Number of Principal Components");
        spinner.setMinimum(3);
        spinner.setIncrement(1);
        spinner.setSelection(PreferenceSupplier.getNumberOfComponents());
        spinner.setMaximum(1000);
        spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IAnalysisSettings analysisSettings;
                if (AnalysisEditorUI.this.samples != null && (analysisSettings = AnalysisEditorUI.this.samples.getAnalysisSettings()) != null) {
                    analysisSettings.setNumberOfPrincipalComponents(spinner.getSelection());
                }
            }
        });
        return spinner;
    }

    private ComboViewer createComboViewerAlgorithm(Composite parent) {
        final ComboViewer comboViewer = new ComboViewer(parent, 8);
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setInput((Object)this.algorithms);
        comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Algorithm) {
                    return ((Algorithm)element).getName();
                }
                return null;
            }
        });
        Combo combo = comboViewer.getCombo();
        combo.setToolTipText("PCA Algorithm");
        combo.setLayoutData((Object)new GridData(768));
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IAnalysisSettings analysisSettings;
                Object object = comboViewer.getStructuredSelection().getFirstElement();
                if (object instanceof Algorithm && AnalysisEditorUI.this.samples != null && (analysisSettings = AnalysisEditorUI.this.samples.getAnalysisSettings()) != null) {
                    analysisSettings.setAlgorithm((Algorithm)object);
                }
            }
        });
        combo.select(0);
        return comboViewer;
    }

    private Button createButtonRun(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Run the PCA analysis.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/execute.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnalysisEditorUI.this.runCalculation(e.display);
                AnalysisEditorUI.this.fireUpdate(e.display, AnalysisEditorUI.this.evaluationPCA);
            }
        });
        return button;
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)new PreferencePage()));
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("2", (IPreferencePage)new PreferencePageScorePlot()));
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("3", (IPreferencePage)new PreferencePageLoadingPlot()));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        AnalysisEditorUI.this.applySettings();
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the settings.");
                    }
                }
            }
        });
    }

    private Composite createToolbarSearch(Composite parent) {
        SearchSupportUI searchSupportUI = new SearchSupportUI(parent, 0);
        searchSupportUI.setLayoutData((Object)new GridData(768));
        searchSupportUI.setSearchListener(new ISearchListener(){

            public void performSearch(String searchText, boolean caseSensitive) {
                AnalysisEditorUI.this.sampleListUI.setSearchText(searchText, caseSensitive);
            }
        });
        return searchSupportUI;
    }

    private TabFolder createDataTab(Composite parent) {
        TabFolder tabFolder = new TabFolder(parent, 128);
        tabFolder.setLayoutData((Object)new GridData(1808));
        tabFolder.setBackground(Colors.WHITE);
        this.sampleListUI = this.createSampleListUI(tabFolder);
        this.preprocessingSettingsUI = this.createPreprocessingUI(tabFolder);
        this.filterSettingsUI = this.createFilterUI(tabFolder);
        return tabFolder;
    }

    private SamplesListUI createSampleListUI(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Sample List");
        SamplesListUI sampleListUI = new SamplesListUI((Composite)tabFolder, 68354);
        Table table = sampleListUI.getTable();
        table.setLayoutData((Object)new GridData(1808));
        tabItem.setControl((Control)table);
        return sampleListUI;
    }

    private PreprocessingSettingsUI createPreprocessingUI(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Preprocessing");
        PreprocessingSettingsUI preprocessingSettingsUI = new PreprocessingSettingsUI((Composite)tabFolder, 0);
        preprocessingSettingsUI.setLayoutData(new GridData(1808));
        tabItem.setControl((Control)preprocessingSettingsUI);
        return preprocessingSettingsUI;
    }

    private FilterSettingsUI createFilterUI(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Filter");
        FilterSettingsUI filterSettingsUI = new FilterSettingsUI((Composite)tabFolder, 0);
        filterSettingsUI.setLayoutData(new GridData(1808));
        tabItem.setControl((Control)filterSettingsUI);
        return filterSettingsUI;
    }

    private void applySettings() {
    }

    private void runCalculation(Display display) {
        if (display != null) {
            try {
                if (this.samples != null) {
                    CalculationExecutor runnable = new CalculationExecutor(this.samples);
                    Shell shell = display.getActiveShell();
                    if (shell != null) {
                        ProgressMonitorDialog monitor = new ProgressMonitorDialog(shell);
                        monitor.run(true, true, (IRunnableWithProgress)runnable);
                    } else {
                        runnable.run((IProgressMonitor)new NullProgressMonitor());
                    }
                    this.evaluationPCA = runnable.getEvaluationPCA();
                }
            }
            catch (Exception e) {
                logger.warn((Object)e);
            }
        }
    }

    private void updateWidgets(IAnalysisSettings analysisSettings) {
        if (analysisSettings != null) {
            this.preprocessingSettingsUI.setInput(analysisSettings.getPreprocessingSettings());
            this.filterSettingsUI.setInput(analysisSettings.getFilterSettings());
            this.spinnerPCs.setSelection(analysisSettings.getNumberOfPrincipalComponents());
            this.comboViewerAlgorithm.getCombo().select(this.getSelectedAlgorithmIndex(analysisSettings));
        } else {
            this.preprocessingSettingsUI.setInput(null);
            this.filterSettingsUI.setInput(null);
        }
    }

    private int getSelectedAlgorithmIndex(IAnalysisSettings analysisSettings) {
        int i = 0;
        while (i < this.algorithms.length) {
            Algorithm algorithm = this.algorithms[i];
            if (algorithm.equals((Object)analysisSettings.getAlgorithm())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void fireUpdate(Display display, final EvaluationPCA evaluationPCA) {
        final IEventBroker eventBroker = Activator.getDefault().getEventBroker();
        if (eventBroker != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (evaluationPCA != null) {
                        eventBroker.send("pca/evaluation/load", (Object)evaluationPCA);
                    } else {
                        eventBroker.send("pca/evaluation/clear", new Object());
                    }
                }
            });
        }
    }
}

