/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.methods;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.chemclipse.converter.methods.MetaProcessorProcessSupplier;
import org.eclipse.chemclipse.converter.methods.MethodConverter;
import org.eclipse.chemclipse.logging.support.Settings;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.methods.IProcessEntry;
import org.eclipse.chemclipse.processing.methods.IProcessMethod;
import org.eclipse.chemclipse.processing.methods.ProcessEntryContainer;
import org.eclipse.chemclipse.processing.supplier.AbstractProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionConsumer;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionContext;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutor;
import org.eclipse.chemclipse.processing.supplier.ProcessorPreferences;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(service={IProcessTypeSupplier.class})
public class MethodProcessTypeSupplier
implements IProcessTypeSupplier,
BundleTrackerCustomizer<Collection<IProcessSupplier<?>>> {
    private static final String PROCESSORS_ENTRY_PATH = "/OSGI-INF/processors/";
    private BundleTracker<Collection<IProcessSupplier<?>>> bundleTracker;
    private final AtomicReference<LogService> logService = new AtomicReference();
    private final List<IProcessSupplier<?>> systemMethods = new ArrayList();

    public String getCategory() {
        return "User Methods";
    }

    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        ArrayList list = new ArrayList();
        Collection<IProcessMethod> userMethods = MethodConverter.getUserMethods();
        HashSet<String> ids = new HashSet<String>();
        for (IProcessMethod processMethod : userMethods) {
            UserMethodProcessSupplier supplier = new UserMethodProcessSupplier(processMethod, this);
            if (ids.contains(supplier.getId())) {
                LogService log = this.logService.get();
                if (log == null) continue;
                log.log(2, "Duplicate id for method " + processMethod.getName() + " (id: " + supplier.getId() + ")");
                continue;
            }
            list.add((IProcessSupplier<?>)supplier);
            ids.add(supplier.getId());
        }
        Collection values = this.bundleTracker.getTracked().values();
        values.forEach(list::addAll);
        list.addAll(this.systemMethods);
        return list;
    }

    public <T> IProcessSupplier<T> getSupplier(String id) {
        String[] split;
        IProcessSupplier<?> supplier = super.getSupplier(id);
        if (supplier == null && (split = id.split(":", 2)).length == 2) {
            String baseId = split[0];
            for (IProcessSupplier<?> s : this.getProcessorSuppliers()) {
                if (!s.getId().startsWith(baseId)) continue;
                if (supplier == null) {
                    supplier = s;
                    continue;
                }
                return null;
            }
        }
        return supplier;
    }

    private static String getUserMethodID(IProcessMethod method) {
        File sourceFile = method.getSourceFile();
        if (sourceFile != null) {
            return MethodProcessTypeSupplier.getID(method, "user:" + sourceFile.getName());
        }
        return MethodProcessTypeSupplier.getID(method, "user");
    }

    private static String getID(IProcessMethod method, String qualifier) {
        String id = "ProcessMethod." + method.getUUID();
        if (qualifier != null) {
            return String.valueOf(id) + ":" + qualifier;
        }
        return id;
    }

    public static DataCategory[] getDataTypes(IProcessMethod method) {
        EnumSet<DataCategory> categories = method.getDataCategories();
        if (categories.isEmpty()) {
            categories = EnumSet.of(DataCategory.CSD, DataCategory.MSD, DataCategory.WSD);
        }
        if (method.getNumberOfEntries() == 0) {
            return categories.toArray(new DataCategory[0]);
        }
        HashSet<DataCategory> entryCategories = new HashSet<DataCategory>();
        for (IProcessEntry entry : method) {
            for (DataCategory entryDataCategory : entry.getDataCategories()) {
                if (!categories.contains(entryDataCategory)) continue;
                entryCategories.add(entryDataCategory);
            }
        }
        return categories.toArray(new DataCategory[0]);
    }

    @Activate
    public void start(BundleContext bundleContext) {
        File[] listFiles;
        this.bundleTracker = new BundleTracker(bundleContext, 32, (BundleTrackerCustomizer)this);
        this.bundleTracker.open();
        File systemMethodFolder = Settings.getSystemMethodDirectory();
        if (systemMethodFolder.isDirectory() && (listFiles = systemMethodFolder.listFiles()) != null) {
            File[] fileArray = listFiles;
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                block15: {
                    File file = fileArray[n2];
                    if (file.isFile()) {
                        try {
                            Throwable throwable = null;
                            Object var9_11 = null;
                            try (FileInputStream inputStream = new FileInputStream(file);){
                                IProcessingInfo<IProcessMethod> load = MethodConverter.load(inputStream, file.getAbsolutePath(), null);
                                IProcessMethod result = (IProcessMethod)load.getProcessingResult();
                                if (result != null) {
                                    this.systemMethods.add((IProcessSupplier<?>)new MetaProcessorProcessSupplier(MethodProcessTypeSupplier.getID(result, "system:" + file.getName()), result, this));
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            LogService log = this.logService.get();
                            if (log == null) break block15;
                            log.log(1, "loading of method from system path " + file.getAbsolutePath() + " failed", (Throwable)e);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    @Deactivate
    public void stop() {
        this.bundleTracker.close();
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    public void setLogService(LogService logService) {
        this.logService.set(logService);
    }

    public void unsetLogService(LogService logService) {
        this.logService.compareAndSet(logService, null);
    }

    public Collection<IProcessSupplier<?>> addingBundle(Bundle bundle, BundleEvent event) {
        ArrayList list = new ArrayList();
        Enumeration entries = bundle.findEntries(PROCESSORS_ENTRY_PATH, "*.ocm", true);
        if (entries != null) {
            while (entries.hasMoreElements()) {
                URL url = (URL)entries.nextElement();
                try {
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try (InputStream inputStream = url.openStream();){
                        String path = url.getPath().replace(PROCESSORS_ENTRY_PATH, "").replace(".ocm", "");
                        String externalForm = url.toExternalForm();
                        IProcessingInfo<IProcessMethod> load = MethodConverter.load(inputStream, externalForm, null);
                        IProcessMethod result = (IProcessMethod)load.getProcessingResult();
                        if (result == null) continue;
                        list.add((IProcessSupplier<?>)new MetaProcessorProcessSupplier(MethodProcessTypeSupplier.getID(result, "bundle:" + bundle.getSymbolicName() + ":" + path), result, this));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    LogService log = this.logService.get();
                    if (log == null) continue;
                    log.log(1, "loading of method from URL " + url + " failed", (Throwable)e);
                }
            }
        }
        return list;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Collection<IProcessSupplier<?>> object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Collection<IProcessSupplier<?>> object) {
    }

    private static final class UserMethodProcessSupplier
    extends AbstractProcessSupplier<Void>
    implements ProcessEntryContainer,
    ProcessExecutor {
        private final IProcessMethod method;

        public UserMethodProcessSupplier(IProcessMethod method, MethodProcessTypeSupplier parent) {
            super(MethodProcessTypeSupplier.getUserMethodID(method), method.getName(), method.getDescription(), null, (IProcessTypeSupplier)parent, MethodProcessTypeSupplier.getDataTypes(method));
            this.method = method;
        }

        public Iterator<IProcessEntry> iterator() {
            return this.method.iterator();
        }

        public int getNumberOfEntries() {
            return this.method.getNumberOfEntries();
        }

        public <X> void execute(ProcessorPreferences<X> preferences, ProcessExecutionContext context) throws Exception {
            ProcessExecutionConsumer consumer = (ProcessExecutionConsumer)context.getContextObject(ProcessExecutionConsumer.class);
            ProcessEntryContainer.applyProcessEntries((ProcessEntryContainer)this.method, (ProcessExecutionContext)context, (ProcessExecutionConsumer)consumer);
        }
    }
}

