/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.model.reports;

import java.io.File;
import org.eclipse.chemclipse.converter.model.reports.ISequenceRecord;
import org.eclipse.chemclipse.converter.model.reports.SequenceRecordAdvice;

public class SequenceRecord
implements ISequenceRecord {
    private String substance = "";
    private String processMethod = "";
    private String reportMethod = "";
    private int vial = 0;
    private double injectionVolume = 0.0;
    private String sampleName = "";
    private double multiplier = 1.0;
    private String dataPath = "";
    private String dataFile = "";
    private String description = "";
    private SequenceRecordAdvice sequenceRecordAdvice = SequenceRecordAdvice.NONE;

    @Override
    public String getSubstance() {
        return this.substance;
    }

    @Override
    public void setSubstance(String substance) {
        this.substance = substance;
    }

    @Override
    public String getProcessMethod() {
        return this.processMethod;
    }

    @Override
    public void setProcessMethod(String processMethod) {
        this.processMethod = processMethod;
    }

    @Override
    public String getReportMethod() {
        return this.reportMethod;
    }

    @Override
    public void setReportMethod(String reportMethod) {
        this.reportMethod = reportMethod;
    }

    @Override
    public int getVial() {
        return this.vial;
    }

    @Override
    public void setVial(int vial) {
        this.vial = vial;
    }

    @Override
    public double getInjectionVolume() {
        return this.injectionVolume;
    }

    @Override
    public void setInjectionVolume(double injectionVolume) {
        this.injectionVolume = injectionVolume;
    }

    @Override
    public String getSampleName() {
        return this.sampleName;
    }

    @Override
    public void setSampleName(String sampleName) {
        this.sampleName = sampleName;
    }

    @Override
    public double getMultiplier() {
        return this.multiplier;
    }

    @Override
    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    @Override
    public String getDataPath() {
        return this.dataPath;
    }

    @Override
    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
        this.validate();
    }

    @Override
    public String getDataFile() {
        return this.dataFile;
    }

    @Override
    public void setDataFile(String dataFile) {
        this.dataFile = dataFile;
        this.validate();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public SequenceRecordAdvice getAdvice() {
        return this.sequenceRecordAdvice;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataFile == null ? 0 : this.dataFile.hashCode());
        result = 31 * result + (this.processMethod == null ? 0 : this.processMethod.hashCode());
        long temp = Double.doubleToLongBits(this.multiplier);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.sampleName == null ? 0 : this.sampleName.hashCode());
        result = 31 * result + (this.substance == null ? 0 : this.substance.hashCode());
        result = 31 * result + this.vial;
        return result;
    }

    private void validate() {
        File file = new File(String.valueOf(this.dataPath) + File.separator + this.dataFile);
        this.sequenceRecordAdvice = file.exists() ? SequenceRecordAdvice.DATA_IS_VALID : SequenceRecordAdvice.FILE_NOT_AVAILABLE;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SequenceRecord other = (SequenceRecord)obj;
        if (this.dataFile == null ? other.dataFile != null : !this.dataFile.equals(other.dataFile)) {
            return false;
        }
        if (this.processMethod == null ? other.processMethod != null : !this.processMethod.equals(other.processMethod)) {
            return false;
        }
        if (Double.doubleToLongBits(this.multiplier) != Double.doubleToLongBits(other.multiplier)) {
            return false;
        }
        if (this.sampleName == null ? other.sampleName != null : !this.sampleName.equals(other.sampleName)) {
            return false;
        }
        if (this.substance == null ? other.substance != null : !this.substance.equals(other.substance)) {
            return false;
        }
        return this.vial == other.vial;
    }

    public String toString() {
        return "SequenceRecord [substance=" + this.substance + ", processMethod=" + this.processMethod + ", vial=" + this.vial + ", sampleName=" + this.sampleName + ", multiplier=" + this.multiplier + ", dataFile=" + this.dataFile + "]";
    }
}

