/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.peak.detector.settings.IPeakDetectorSettings;
import org.eclipse.chemclipse.chromatogram.peak.detector.support.IRawPeak;
import org.eclipse.chemclipse.chromatogram.wsd.peak.detector.core.IPeakDetectorWSD;
import org.eclipse.chemclipse.chromatogram.wsd.peak.detector.settings.IPeakDetectorSettingsWSD;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.core.BasePeakDetector;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.settings.PeakDetectorSettingsWSD;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.support.FirstDerivativeDetectorSlope;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.support.FirstDerivativeDetectorSlopes;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.support.IFirstDerivativeDetectorSlopes;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignalsModifier;
import org.eclipse.chemclipse.model.support.IScanRange;
import org.eclipse.chemclipse.model.support.ScanRange;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.core.Point;
import org.eclipse.chemclipse.numeric.statistics.WindowSize;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramPeakWSD;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.chemclipse.wsd.model.core.support.PeakBuilderWSD;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakDetectorWSD
extends BasePeakDetector
implements IPeakDetectorWSD {
    private static final Logger logger = Logger.getLogger(PeakDetectorWSD.class);
    private static final String DETECTOR_DESCRIPTION = "Peak Detector First Derivative";
    private static float NORMALIZATION_BASE = 100000.0f;
    private static int CONSECUTIVE_SCAN_STEPS = 3;

    public IProcessingInfo detect(IChromatogramSelectionWSD chromatogramSelection, IPeakDetectorSettingsWSD detectorSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = this.validate((IChromatogramSelection)chromatogramSelection, (IPeakDetectorSettings)detectorSettings, monitor);
        if (!processingInfo.hasErrorMessages()) {
            if (detectorSettings instanceof PeakDetectorSettingsWSD) {
                PeakDetectorSettingsWSD peakDetectorSettings = (PeakDetectorSettingsWSD)detectorSettings;
                List<IChromatogramPeakWSD> peaks = this.detectPeaks(chromatogramSelection, peakDetectorSettings, monitor);
                IChromatogramWSD chromatogram = (IChromatogramWSD)chromatogramSelection.getChromatogram();
                for (IChromatogramPeakWSD peak : peaks) {
                    chromatogram.addPeak((IPeak)peak);
                }
                processingInfo.addMessage((IProcessingMessage)new ProcessingMessage(MessageType.INFO, DETECTOR_DESCRIPTION, "Peaks have been detected successfully."));
            } else {
                logger.warn((Object)("Settings is not of type: " + PeakDetectorSettingsWSD.class));
            }
        }
        return processingInfo;
    }

    public IProcessingInfo detect(IChromatogramSelectionWSD chromatogramSelection, IProgressMonitor monitor) {
        PeakDetectorSettingsWSD peakDetectorSettings = PreferenceSupplier.getPeakDetectorSettingsWSD();
        return this.detect(chromatogramSelection, (IPeakDetectorSettingsWSD)peakDetectorSettings, monitor);
    }

    public List<IChromatogramPeakWSD> detectPeaks(IChromatogramSelectionWSD chromatogramSelection, PeakDetectorSettingsWSD peakDetectorSettings, IProgressMonitor monitor) {
        IFirstDerivativeDetectorSlopes slopes = PeakDetectorWSD.getFirstDerivativeSlopes(chromatogramSelection, peakDetectorSettings.getMovingAverageWindowSize());
        List<IRawPeak> rawPeaks = PeakDetectorWSD.getRawPeaks(slopes, peakDetectorSettings.getThreshold(), monitor);
        return this.extractPeaks(rawPeaks, (IChromatogramWSD)chromatogramSelection.getChromatogram(), peakDetectorSettings);
    }

    private List<IChromatogramPeakWSD> extractPeaks(List<IRawPeak> rawPeaks, IChromatogramWSD chromatogram, PeakDetectorSettingsWSD peakDetectorSettings) {
        ArrayList<IChromatogramPeakWSD> peaks = new ArrayList<IChromatogramPeakWSD>();
        IChromatogramPeakWSD peak = null;
        ScanRange scanRange = null;
        for (IRawPeak rawPeak : rawPeaks) {
            try {
                scanRange = new ScanRange(rawPeak.getStartScan(), rawPeak.getStopScan());
                peak = PeakBuilderWSD.createPeak((IChromatogramWSD)chromatogram, (IScanRange)scanRange, (boolean)peakDetectorSettings.isIncludeBackground());
                if (!this.isValidPeak(peak)) continue;
                peak.setDetectorDescription(DETECTOR_DESCRIPTION);
                peaks.add(peak);
            }
            catch (IllegalArgumentException e) {
                logger.warn((Object)e);
            }
            catch (PeakException e) {
                logger.warn((Object)e);
            }
        }
        return peaks;
    }

    public static IFirstDerivativeDetectorSlopes getFirstDerivativeSlopes(IChromatogramSelectionWSD chromatogramSelection, WindowSize window) {
        TotalScanSignals signals = new TotalScanSignals((IChromatogramSelection)chromatogramSelection);
        TotalScanSignalsModifier.normalize((ITotalScanSignals)signals, (float)NORMALIZATION_BASE);
        FirstDerivativeDetectorSlopes slopes = new FirstDerivativeDetectorSlopes((ITotalScanSignals)signals);
        int startScan = signals.getStartScan();
        int stopScan = signals.getStopScan();
        int scan = startScan;
        while (scan < stopScan) {
            ITotalScanSignal s1 = signals.getTotalScanSignal(scan);
            ITotalScanSignal s2 = signals.getNextTotalScanSignal(scan);
            if (s1 != null && s2 != null) {
                Point p1 = new Point((double)s1.getRetentionTime(), (double)s1.getTotalSignal());
                Point p2 = new Point((double)s2.getRetentionTime(), (double)s2.getTotalSignal());
                FirstDerivativeDetectorSlope slope = new FirstDerivativeDetectorSlope((IPoint)p1, (IPoint)p2, s1.getRetentionTime());
                slopes.add(slope);
            }
            ++scan;
        }
        slopes.calculateMovingAverage(window);
        return slopes;
    }

    private boolean isValidPeak(IChromatogramPeakWSD peak) {
        return peak != null;
    }
}

