/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.runtime;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.runtime.AmdisSupport;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.runtime.IAmdisSupport;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.runtime.IExtendedRuntimeSupport;
import org.eclipse.chemclipse.support.runtime.AbstractLinuxWineSupport;

public class LinuxWineSupport
extends AbstractLinuxWineSupport
implements IExtendedRuntimeSupport {
    private IAmdisSupport amdisSupport = new AmdisSupport(this);

    public LinuxWineSupport(String application, String parameter) throws FileNotFoundException {
        super(application, parameter);
    }

    public int getSleepMillisecondsBeforeExecuteRunCommand() {
        return 4000;
    }

    public boolean isValidApplicationExecutable() {
        return this.amdisSupport.validateExecutable();
    }

    @Override
    public IAmdisSupport getAmdisSupport() {
        return this.amdisSupport;
    }

    public Process executeKillCommand() throws IOException {
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(this.getKillCommand());
        return process;
    }

    public Process executeOpenCommand() throws IOException {
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(this.getOpenCommand());
        return process;
    }

    private String getKillCommand() {
        String command = "";
        if (this.isValidApplicationExecutable()) {
            StringBuilder builder = new StringBuilder();
            builder.append("pkill -f");
            builder.append(" ");
            builder.append("AMDIS");
            command = builder.toString();
        }
        return command;
    }

    private String getOpenCommand() {
        StringBuilder builder = new StringBuilder();
        builder.append("env WINEPREFIX=");
        builder.append(this.getWineEnvironment());
        builder.append(" ");
        builder.append("wine start");
        builder.append(" ");
        builder.append(this.getWineApplication().replace("AMDIS32$.exe", "AMDIS_32.exe"));
        return builder.toString();
    }
}

