/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.pdfbox.extensions.core;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.util.Matrix;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.pdfbox.extensions.core.PDTable;
import org.eclipse.chemclipse.pdfbox.extensions.elements.BoxElement;
import org.eclipse.chemclipse.pdfbox.extensions.elements.CellElement;
import org.eclipse.chemclipse.pdfbox.extensions.elements.IReferenceElement;
import org.eclipse.chemclipse.pdfbox.extensions.elements.ImageElement;
import org.eclipse.chemclipse.pdfbox.extensions.elements.LineElement;
import org.eclipse.chemclipse.pdfbox.extensions.elements.TableElement;
import org.eclipse.chemclipse.pdfbox.extensions.elements.TextElement;
import org.eclipse.chemclipse.pdfbox.extensions.settings.ConverterFactory;
import org.eclipse.chemclipse.pdfbox.extensions.settings.IPageBaseConverter;
import org.eclipse.chemclipse.pdfbox.extensions.settings.IUnitConverter;
import org.eclipse.chemclipse.pdfbox.extensions.settings.PageSettings;
import org.eclipse.chemclipse.pdfbox.extensions.settings.ReferenceX;
import org.eclipse.chemclipse.pdfbox.extensions.settings.ReferenceY;
import org.eclipse.chemclipse.pdfbox.extensions.settings.TextOption;

public class PageUtil {
    private static final Logger logger = Logger.getLogger(PageUtil.class);
    private static final String TEXT_SHORTEN_MARKER = "...";
    private PDDocument document = null;
    private PDPage page = null;
    private PDPageContentStream contentStream = null;
    private IPageBaseConverter pageBaseConverter = null;
    private IUnitConverter unitConverter = null;
    private boolean landscape;

    public PageUtil(PDDocument document, PageSettings pageSettings) throws IOException {
        this.document = document;
        this.page = new PDPage(pageSettings.getPDRectangle());
        this.document.addPage(this.page);
        this.contentStream = new PDPageContentStream(document, this.page);
        this.pageBaseConverter = ConverterFactory.getInstance(pageSettings.getPageBase());
        this.unitConverter = ConverterFactory.getInstance(pageSettings.getUnit());
        this.landscape = pageSettings.isLandscape();
        if (this.landscape) {
            this.page.setRotation(-90);
            float x = 0.0f;
            float y = pageSettings.getPDRectangle().getHeight();
            this.contentStream.transform(Matrix.getTranslateInstance((float)x, (float)y));
            this.contentStream.transform(Matrix.getRotateInstance((double)Math.toRadians(-90.0), (float)0.0f, (float)0.0f));
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public PDDocument getDocument() {
        return this.document;
    }

    public PDPage getPage() {
        return this.page;
    }

    public void close() throws IOException {
        if (this.contentStream != null) {
            this.contentStream.close();
        }
    }

    public float getPositionBaseX(float x) {
        return this.pageBaseConverter.getPositionX(this.getPageWidthPt(), this.unitConverter.convertToPt(x));
    }

    public float getPositionBaseY(float y) {
        return this.pageBaseConverter.getPositionY(this.getPageHeightPt(), this.unitConverter.convertToPt(y));
    }

    public float calculateTextWidth(PDFont font, float fontSize, String text) throws IOException {
        return this.unitConverter.convertFromPt(this.calculateTextWidthPt(font, fontSize, text));
    }

    public float calculateTextHeight(PDFont font, float fontSize) {
        return this.unitConverter.convertFromPt(this.calculateTextHeightPt(font, fontSize));
    }

    public float printText(TextElement textElement) throws IOException {
        float height = 0.0f;
        String text = textElement.getText();
        if (text.length() > 0) {
            float textHeight = 0.0f;
            switch (textElement.getTextOption()) {
                case NONE: {
                    textHeight = this.printTextDefault(textElement);
                    break;
                }
                case SHORTEN: {
                    textHeight = this.printTextShorten(textElement);
                    break;
                }
                case MULTI_LINE: {
                    textHeight = this.printTextMultiLine(textElement);
                    break;
                }
                default: {
                    logger.warn((Object)("Option not supported: " + (Object)((Object)textElement.getTextOption())));
                    logger.warn((Object)("Option selected instead: " + (Object)((Object)TextOption.NONE)));
                    textHeight = this.printTextDefault(textElement);
                }
            }
            float minHeight = this.unitConverter.convertToPt(textElement.getMinHeight());
            height = textHeight > minHeight ? textHeight : minHeight;
        }
        return this.unitConverter.convertFromPt(height);
    }

    public void printImage(ImageElement imageElement) throws IOException {
        PDImageXObject image = imageElement.getImage();
        float width = this.unitConverter.convertToPt(imageElement.getWidth());
        float height = this.unitConverter.convertToPt(imageElement.getHeight());
        float x = this.calculateX(imageElement, width, width);
        float y = this.calculateY(imageElement, height);
        this.printImage(image, x, y, width, height);
    }

    public void printLine(LineElement lineElement) throws IOException {
        float width = this.unitConverter.convertToPt(lineElement.getLineWidth());
        float x0 = this.getPositionBaseX(lineElement.getX());
        float y0 = this.getPositionBaseY(lineElement.getY());
        float x1 = this.getPositionBaseX(lineElement.getX1());
        float y1 = this.getPositionBaseY(lineElement.getY1());
        this.contentStream.setStrokingColor(lineElement.getColor());
        this.contentStream.setLineWidth(width);
        this.contentStream.moveTo(x0, y0);
        this.contentStream.lineTo(x1, y1);
        this.contentStream.stroke();
    }

    public void printBox(BoxElement boxElement) throws IOException {
        Color color = boxElement.getColor();
        float x = this.getPositionBaseX(boxElement.getX());
        float y = this.getPositionBaseY(boxElement.getY() + boxElement.getHeight());
        float width = this.unitConverter.convertToPt(boxElement.getWidth());
        float height = this.unitConverter.convertToPt(boxElement.getHeight());
        this.contentStream.setNonStrokingColor(color);
        this.contentStream.addRect(x, y, width, height);
        this.contentStream.fill();
    }

    public void printTable(TableElement tableElement) throws IOException {
        if (this.isTableValid(tableElement)) {
            PDTable pdTable = tableElement.getPDTable();
            float y = this.unitConverter.convertToPt(tableElement.getY());
            for (List<CellElement> titleRow : pdTable.getHeader()) {
                y += this.printTableRow(y, tableElement, titleRow, tableElement.getColorTitle());
            }
            if (pdTable.getNumberDataRows() > 0) {
                int i = pdTable.getStartIndex();
                while (i < pdTable.getStopIndex()) {
                    List<CellElement> rowCells = pdTable.getDataRow(i);
                    Color color = i % 2 == 0 ? null : tableElement.getColorData();
                    y += this.printTableRow(y, tableElement, rowCells, color);
                    ++i;
                }
            }
        } else {
            logger.warn((Object)"The pdTable is invalid.");
            float x = tableElement.getX();
            float y = tableElement.getY();
            this.printText(new TextElement(x, y, Float.MAX_VALUE).setText("The table is invalid."));
        }
    }

    private boolean isTableValid(TableElement tableElement) {
        PDTable pdTable = tableElement.getPDTable();
        boolean isValid = pdTable.isValid();
        if (isValid) {
            float heightPage;
            float heightTable;
            float widthPage;
            float widthTable = this.unitConverter.convertToPt(tableElement.getX() + pdTable.getWidth());
            if (widthTable > (widthPage = this.getPageWidthPt())) {
                logger.warn((Object)("The table width (" + widthTable + ")is larger then the page width (" + widthPage + ")."));
            }
            if ((heightTable = this.unitConverter.convertToPt((float)(pdTable.getStopIndex() - pdTable.getStartIndex() + 1 + pdTable.getNumberHeaderRows()) * tableElement.getColumnHeight() + tableElement.getY())) > (heightPage = this.getPageHeightPt())) {
                logger.warn((Object)("The table height (" + heightTable + ")is larger then the page height (" + heightPage + ")."));
            }
        }
        return isValid;
    }

    private float getPageHeightPt() {
        PDRectangle rectangle = this.page.getMediaBox();
        return this.landscape ? rectangle.getWidth() : rectangle.getHeight();
    }

    private float getPageWidthPt() {
        PDRectangle rectangle = this.page.getMediaBox();
        return this.landscape ? rectangle.getHeight() : rectangle.getWidth();
    }

    private float calculateTextHeightPt(PDFont font, float fontSize) {
        PDRectangle rectangle = font.getFontDescriptor().getFontBoundingBox();
        return rectangle.getHeight() / 1000.0f * fontSize * 0.68f;
    }

    private float calculateTextWidthPt(PDFont font, float fontSize, String text) throws IOException {
        return font.getStringWidth(text) / 1000.0f * fontSize;
    }

    private void printImage(PDImageXObject image, float x, float y, float width, float height) throws IOException {
        this.contentStream.drawImage(image, x, y, width, height);
    }

    private float printTableRow(float y, TableElement tableElement, List<CellElement> cells, Color color) throws IOException {
        PDTable pdTable = tableElement.getPDTable();
        float _x = tableElement.getX();
        float _y = this.unitConverter.convertFromPt(y);
        float _height = this.unitConverter.convertFromPt(this.calculateRowHeight(cells, this.unitConverter.convertToPt(tableElement.getColumnHeight())));
        float _lineWidth = tableElement.getLineWidth();
        if (color != null) {
            float _extra = this.unitConverter.convertFromPt(0.3f);
            this.printBox(new BoxElement(_x, _y, pdTable.getWidth(), _height + _extra).setColor(color));
        }
        for (CellElement cell : cells) {
            cell.setX(_x + tableElement.getTextOffsetX());
            cell.setY(_y + tableElement.getTextOffsetY());
            this.printText(cell);
            if (cell.isBorderSet()) {
                float _xRight = _x + cell.getMaxWidth();
                float _yHeight = _y + _height;
                if (cell.isBorderSet(CellElement.BORDER_LEFT)) {
                    this.printLine(new LineElement(_x, _y, _x, _yHeight).setLineWidth(_lineWidth));
                }
                if (cell.isBorderSet(CellElement.BORDER_RIGHT)) {
                    this.printLine(new LineElement(_xRight, _y, _xRight, _yHeight).setLineWidth(_lineWidth));
                }
                if (cell.isBorderSet(CellElement.BORDER_TOP)) {
                    this.printLine(new LineElement(_x, _y, _xRight, _y).setLineWidth(_lineWidth));
                }
                if (cell.isBorderSet(CellElement.BORDER_BOTTOM)) {
                    this.printLine(new LineElement(_x, _yHeight, _xRight, _yHeight).setLineWidth(_lineWidth));
                }
            }
            _x += cell.getMaxWidth();
        }
        return this.unitConverter.convertToPt(_height);
    }

    private float calculateX(IReferenceElement referenceElement, float elementWidth, float maxWidth) throws IOException {
        float x;
        ReferenceX referenceX = referenceElement.getReferenceX();
        switch (referenceX) {
            case LEFT: {
                x = this.getPositionBaseX(referenceElement.getX());
                break;
            }
            case RIGHT: {
                x = this.getPositionBaseX(referenceElement.getX()) + maxWidth - elementWidth;
                break;
            }
            default: {
                logger.warn((Object)("Option not supported: " + (Object)((Object)referenceX)));
                logger.warn((Object)("Option selected instead: " + (Object)((Object)ReferenceX.LEFT)));
                x = this.getPositionBaseX(referenceElement.getX());
            }
        }
        return x;
    }

    private float calculateY(IReferenceElement referenceElement, float elementHeight) {
        float y;
        ReferenceY referenceY = referenceElement.getReferenceY();
        switch (referenceY) {
            case TOP: {
                y = this.getPositionBaseY(referenceElement.getY()) - elementHeight;
                break;
            }
            case CENTER: {
                y = this.getPositionBaseY(referenceElement.getY()) - elementHeight / 2.0f;
                break;
            }
            case BOTTOM: {
                y = this.getPositionBaseY(referenceElement.getY());
                break;
            }
            default: {
                logger.warn((Object)("Option not supported: " + (Object)((Object)referenceY)));
                logger.warn((Object)("Option selected instead: " + (Object)((Object)ReferenceY.BOTTOM)));
                y = this.getPositionBaseY(referenceElement.getY());
            }
        }
        return y;
    }

    private float printTextDefault(TextElement textElement) throws IOException {
        PDFont font = textElement.getFont();
        float fontSize = textElement.getFontSize();
        Color color = textElement.getColor();
        String text = textElement.getText();
        float maxWidth = this.unitConverter.convertToPt(textElement.getMaxWidth());
        float textWidth = this.calculateTextWidthPt(font, fontSize, text);
        float textHeight = this.calculateTextHeightPt(font, fontSize);
        float x = this.calculateX(textElement, textWidth, maxWidth);
        float y = this.calculateY(textElement, textHeight);
        return this.printText(font, fontSize, color, x, y, text);
    }

    private float printTextShorten(TextElement textElement) throws IOException {
        PDFont font = textElement.getFont();
        float fontSize = textElement.getFontSize();
        Color color = textElement.getColor();
        String text = textElement.getText();
        float maxWidth = this.unitConverter.convertToPt(textElement.getMaxWidth());
        float textWidth = this.calculateTextWidthPt(font, fontSize, text);
        float textHeight = this.calculateTextHeightPt(font, fontSize);
        float x = this.unitConverter.convertToPt(textElement.getX());
        float y = this.calculateY(textElement, textHeight);
        String shortenedText = text;
        ReferenceX referenceX = textElement.getReferenceX();
        switch (referenceX) {
            case LEFT: {
                shortenedText = this.shortenStringLeft(text, textWidth, maxWidth);
                break;
            }
            case RIGHT: {
                shortenedText = this.shortenStringRight(text, textWidth, maxWidth);
                break;
            }
            default: {
                logger.warn((Object)("Option not supported: " + (Object)((Object)referenceX)));
                logger.warn((Object)("Option selected instead: " + (Object)((Object)ReferenceX.LEFT)));
                shortenedText = this.shortenStringLeft(text, textWidth, maxWidth);
            }
        }
        return this.printText(font, fontSize, color, x, y, shortenedText);
    }

    private float printTextMultiLine(TextElement textElement) throws IOException {
        PDFont font = textElement.getFont();
        float fontSize = textElement.getFontSize();
        Color color = textElement.getColor();
        String text = textElement.getText();
        float maxWidth = this.unitConverter.convertToPt(textElement.getMaxWidth());
        float textWidth = this.calculateTextWidthPt(font, fontSize, text);
        float minHeight = this.unitConverter.convertToPt(textElement.getMinHeight());
        float textHeight = this.calculateTextHeightPt(font, fontSize);
        float x = this.unitConverter.convertToPt(textElement.getX());
        float y = this.calculateY(textElement, textHeight);
        List<String> parts = this.cutStringMultiLine(text, textWidth, maxWidth);
        float offset = 0.0f;
        for (String part : parts) {
            float height;
            offset += (height = this.printText(font, fontSize, color, x, y - offset, part)) > minHeight ? height : minHeight;
        }
        return offset;
    }

    private float printText(PDFont font, float fontSize, Color color, float x, float y, String text) throws IOException {
        this.contentStream.setFont(font, fontSize);
        this.contentStream.setNonStrokingColor(color);
        this.contentStream.beginText();
        this.contentStream.newLineAtOffset(x, y);
        this.contentStream.showText(text);
        this.contentStream.endText();
        return this.calculateTextHeightPt(font, fontSize);
    }

    private String shortenStringLeft(String text, float textWidth, float maxWidth) {
        int endIndex = (int)((float)text.length() / textWidth * maxWidth) - 3;
        if (textWidth > maxWidth && endIndex > 0) {
            return String.valueOf(text.substring(0, endIndex)) + TEXT_SHORTEN_MARKER;
        }
        return text;
    }

    private String shortenStringRight(String text, float textWidth, float maxWidth) {
        int length = text.length();
        int startIndex = length - (int)((float)length / textWidth * maxWidth);
        if (textWidth > maxWidth && startIndex > 0) {
            return TEXT_SHORTEN_MARKER + text.substring(startIndex, length);
        }
        return text;
    }

    private List<String> cutStringMultiLine(String text, float textWidth, float maxWidth) {
        ArrayList<String> elements = new ArrayList<String>();
        int textLength = text.length();
        int partLength = (int)((float)textLength / textWidth * maxWidth);
        int parts = textLength / partLength + 1;
        int i = 0;
        while (i < parts) {
            int startIndex;
            int stopIndex = (startIndex = i * partLength) + partLength;
            elements.add(text.substring(startIndex, stopIndex > textLength ? textLength : stopIndex));
            ++i;
        }
        return elements;
    }

    private float calculateRowHeight(List<CellElement> cells, float minHeight) throws IOException {
        float rowHeight = minHeight;
        for (CellElement cell : cells) {
            if (!cell.getTextOption().equals((Object)TextOption.MULTI_LINE)) continue;
            String text = cell.getText();
            PDFont font = cell.getFont();
            float fontSize = cell.getFontSize();
            float textWidth = this.calculateTextWidthPt(font, fontSize, text);
            float textHeight = this.calculateTextHeightPt(font, fontSize);
            List<String> parts = this.cutStringMultiLine(text, textWidth, this.unitConverter.convertToPt(cell.getMaxWidth()));
            float cellHeight = 0.0f;
            Iterator<String> iterator = parts.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                cellHeight += textHeight > minHeight ? textHeight : minHeight;
            }
            rowHeight = Math.max(rowHeight, cellHeight);
        }
        return rowHeight;
    }
}

