/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.ascii.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.converter.io.AbstractMassSpectraReader;
import org.eclipse.chemclipse.msd.converter.io.IMassSpectraReader;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.implementation.MassSpectra;
import org.eclipse.chemclipse.msd.model.implementation.ScanMSD;
import org.eclipse.core.runtime.IProgressMonitor;

public class MassSpectraReader
extends AbstractMassSpectraReader
implements IMassSpectraReader {
    private static final Logger logger = Logger.getLogger(MassSpectraReader.class);

    public IMassSpectra read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        MassSpectra massSpectra = new MassSpectra();
        ScanMSD massSpectrum = new ScanMSD();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            String[] temp;
            if ((line = line.trim()).length() == 0 || line.startsWith(";")) continue;
            if (line.toUpperCase().matches("^#.*TIME.*=.*")) {
                int retentionTime = (int)((double)this.getNumberValue(line) * 1000.0);
                massSpectrum.setRetentionTime(retentionTime);
                continue;
            }
            if (line.toUpperCase().matches("^#.*INDEX.*=.*")) {
                float retentionIndex = this.getNumberValue(line);
                massSpectrum.setRetentionIndex(retentionIndex);
                continue;
            }
            if (line.startsWith("#") || (temp = line.split("\\s+")).length < 2) continue;
            this.addIon((IScanMSD)massSpectrum, temp);
        }
        bufferedReader.close();
        massSpectra.addMassSpectrum((IScanMSD)massSpectrum);
        return massSpectra;
    }

    private void addIon(IScanMSD massSpectrum, String[] temp) {
        try {
            double mz = Double.parseDouble(temp[0]);
            float abundance = (float)Double.parseDouble(temp[1].replace(";", ""));
            massSpectrum.addIon((IIon)new Ion(mz, abundance));
        }
        catch (NumberFormatException e) {
            logger.warn((Object)e);
        }
        catch (AbundanceLimitExceededException e) {
            logger.warn((Object)e);
        }
        catch (IonLimitExceededException e) {
            logger.warn((Object)e);
        }
    }

    private float getNumberValue(String line) {
        float number = 0.0f;
        String value = line.substring(line.indexOf("=") + 1);
        try {
            number = (float)Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            logger.warn((Object)e);
        }
        return number;
    }
}

