/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xir.converter.core;

import java.io.File;
import java.util.List;
import org.eclipse.chemclipse.converter.core.Converter;
import org.eclipse.chemclipse.converter.core.IMagicNumberMatcher;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.converter.scan.IScanConverterSupport;
import org.eclipse.chemclipse.converter.scan.ScanConverterSupport;
import org.eclipse.chemclipse.converter.scan.ScanSupplier;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.xir.converter.core.IScanExportConverter;
import org.eclipse.chemclipse.xir.converter.core.IScanImportConverter;
import org.eclipse.chemclipse.xir.model.core.IScanXIR;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class ScanConverterXIR {
    private static final Logger logger = Logger.getLogger(ScanConverterXIR.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.xir.converter.scanSupplier";

    private ScanConverterXIR() {
    }

    public static IProcessingInfo<IScanXIR> convert(File file, String converterId, IProgressMonitor monitor) {
        IScanImportConverter<IScanXIR> importConverter = ScanConverterXIR.getScanImportConverter(converterId);
        Object processingInfo = importConverter != null ? importConverter.convert(file, monitor) : ScanConverterXIR.getProcessingError(file);
        return processingInfo;
    }

    public static IProcessingInfo<IScanXIR> convert(File file, IProgressMonitor monitor) {
        return ScanConverterXIR.getScan(file, false, monitor);
    }

    private static IProcessingInfo<IScanXIR> getScan(File file, boolean overview, IProgressMonitor monitor) {
        IScanConverterSupport converterSupport = ScanConverterXIR.getScanConverterSupport();
        try {
            List availableConverterIds = converterSupport.getAvailableConverterIds(file);
            for (String converterId : availableConverterIds) {
                IProcessingInfo<IScanXIR> processingInfo;
                IScanImportConverter<IScanXIR> importConverter = ScanConverterXIR.getScanImportConverter(converterId);
                if (importConverter == null || (processingInfo = importConverter.convert(file, monitor)).hasErrorMessages()) continue;
                IScanXIR object = (IScanXIR)processingInfo.getProcessingResult();
                return processingInfo;
            }
        }
        catch (NoConverterAvailableException e) {
            logger.info((Object)e);
        }
        return ScanConverterXIR.getProcessingError(file);
    }

    public static IProcessingInfo<IScanXIR> convert(File file, IScanXIR scan, String converterId, IProgressMonitor monitor) {
        IScanExportConverter<IScanXIR> exportConverter = ScanConverterXIR.getScanExportConverter(converterId);
        Object processingInfo = exportConverter != null ? exportConverter.convert(file, scan, monitor) : ScanConverterXIR.getProcessingError(file);
        return processingInfo;
    }

    private static IScanImportConverter<IScanXIR> getScanImportConverter(String converterId) {
        IConfigurationElement element = ScanConverterXIR.getConfigurationElement(converterId);
        IScanImportConverter instance = null;
        if (element != null) {
            try {
                instance = (IScanImportConverter)element.createExecutableExtension("importConverter");
            }
            catch (CoreException e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return instance;
    }

    private static IScanExportConverter<IScanXIR> getScanExportConverter(String converterId) {
        IConfigurationElement element = ScanConverterXIR.getConfigurationElement(converterId);
        IScanExportConverter instance = null;
        if (element != null) {
            try {
                instance = (IScanExportConverter)element.createExecutableExtension("exportConverter");
            }
            catch (CoreException e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String converterId) {
        IConfigurationElement[] elements;
        if ("".equals(converterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute("id").equals(converterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    public static IScanConverterSupport getScanConverterSupport() {
        IConfigurationElement[] extensions;
        ScanConverterSupport converterSupport = new ScanConverterSupport(DataCategory.XIR);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            ScanSupplier supplier = new ScanSupplier();
            supplier.setFileExtension(element.getAttribute("fileExtension"));
            supplier.setFileName(element.getAttribute("fileName"));
            supplier.setDirectoryExtension(element.getAttribute("directoryExtension"));
            if (Converter.isValid((String)supplier.getFileExtension()) && Converter.isValid((String)supplier.getFileName()) && Converter.isValid((String)supplier.getDirectoryExtension())) {
                supplier.setId(element.getAttribute("id"));
                supplier.setDescription(element.getAttribute("description"));
                supplier.setFilterName(element.getAttribute("filterName"));
                supplier.setExportable(Boolean.valueOf(element.getAttribute("isExportable")).booleanValue());
                supplier.setImportable(Boolean.valueOf(element.getAttribute("isImportable")).booleanValue());
                supplier.setMagicNumberMatcher(ScanConverterXIR.getMagicNumberMatcher(element));
                converterSupport.add((ISupplier)supplier);
            }
            ++n2;
        }
        return converterSupport;
    }

    private static IMagicNumberMatcher getMagicNumberMatcher(IConfigurationElement element) {
        IMagicNumberMatcher magicNumberMatcher;
        try {
            magicNumberMatcher = (IMagicNumberMatcher)element.createExecutableExtension("importMagicNumberMatcher");
        }
        catch (Exception e) {
            magicNumberMatcher = null;
        }
        return magicNumberMatcher;
    }

    private static <T> IProcessingInfo<T> getProcessingError(File file) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addErrorMessage("Scan Converter", "No suitable converter was found for: " + file);
        return processingInfo;
    }
}

