/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.calibration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.chemclipse.model.columns.IRetentionIndexEntry;
import org.eclipse.chemclipse.model.columns.ISeparationColumnIndices;
import org.eclipse.chemclipse.swt.ui.components.ISearchListener;
import org.eclipse.chemclipse.swt.ui.components.SearchSupportUI;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.calibration.CalibrationEditUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.calibration.ICalibrationEditListener;
import org.eclipse.chemclipse.ux.extension.xxd.ui.calibration.IUpdateListener;
import org.eclipse.chemclipse.ux.extension.xxd.ui.calibration.RetentionIndexTableViewerUI;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class RetentionIndexUI
extends Composite {
    private SearchSupportUI searchSupportUI;
    private CalibrationEditUI calibrationEditUI;
    private RetentionIndexTableViewerUI retentionIndexListUI;
    private IUpdateListener updateListener = null;
    private ISeparationColumnIndices separationColumnIndices = null;

    public RetentionIndexUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void setUpdateListener(IUpdateListener updateListener) {
        this.updateListener = updateListener;
    }

    public void addRetentionIndexEntries(List<IRetentionIndexEntry> retentionIndexEntries) {
        this.calibrationEditUI.addRetentionIndexEntries(retentionIndexEntries);
    }

    public void setInput(ISeparationColumnIndices separationColumnIndices) {
        this.separationColumnIndices = separationColumnIndices;
        this.retentionIndexListUI.setInput(separationColumnIndices);
    }

    public RetentionIndexTableViewerUI getRetentionIndexTableViewerUI() {
        return this.retentionIndexListUI;
    }

    public void setSearchVisibility(boolean visible) {
        PartSupport.setCompositeVisibility((Composite)this.searchSupportUI, (boolean)visible);
    }

    public boolean toggleSearchVisibility() {
        return PartSupport.toggleCompositeVisibility((Composite)this.searchSupportUI);
    }

    public void setEditVisibility(boolean visible) {
        PartSupport.setCompositeVisibility((Composite)this.calibrationEditUI, (boolean)visible);
    }

    public boolean toggleEditVisibility() {
        return PartSupport.toggleCompositeVisibility((Composite)this.calibrationEditUI);
    }

    public void toggleTableEdit() {
        boolean editEnabled = !this.retentionIndexListUI.isEditEnabled();
        this.retentionIndexListUI.setEditEnabled(editEnabled);
    }

    public void enableTableEdit(boolean editEnabled) {
        this.retentionIndexListUI.setEditEnabled(editEnabled);
    }

    public String getSearchText() {
        return this.searchSupportUI.getSearchText();
    }

    private void createControl() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        composite.setLayout((Layout)gridLayout);
        this.searchSupportUI = this.createToolbarSearch(composite);
        this.calibrationEditUI = this.createToolbarEdit(composite);
        this.retentionIndexListUI = this.createTableField(composite);
    }

    private SearchSupportUI createToolbarSearch(Composite parent) {
        SearchSupportUI searchSupportUI = new SearchSupportUI(parent, 0);
        searchSupportUI.setBackground(Colors.WHITE);
        searchSupportUI.setLayoutData((Object)new GridData(768));
        searchSupportUI.setSearchListener(new ISearchListener(){

            public void performSearch(String searchText, boolean caseSensitive) {
                RetentionIndexUI.this.retentionIndexListUI.setSearchText(searchText, caseSensitive);
                RetentionIndexUI.this.fireUpdate();
            }
        });
        return searchSupportUI;
    }

    private CalibrationEditUI createToolbarEdit(Composite parent) {
        final CalibrationEditUI calibrationEditUI = new CalibrationEditUI(parent, 0);
        calibrationEditUI.setLayoutData(new GridData(768));
        calibrationEditUI.setCalibrationEditListener(new ICalibrationEditListener(){

            @Override
            public void delete() {
                Table table;
                int index;
                if (RetentionIndexUI.this.separationColumnIndices != null && (index = (table = RetentionIndexUI.this.retentionIndexListUI.getTable()).getSelectionIndex()) >= 0) {
                    MessageBox messageBox = new MessageBox(calibrationEditUI.getShell(), 8);
                    messageBox.setText("Delete reference(s)?");
                    messageBox.setMessage("Would you like to delete the reference(s)?");
                    if (messageBox.open() == 32) {
                        TableItem[] tableItems;
                        ArrayList<Integer> keysToRemove = new ArrayList<Integer>();
                        TableItem[] tableItemArray = tableItems = table.getSelection();
                        int n = tableItems.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableItem tableItem = tableItemArray[n2];
                            Object object = tableItem.getData();
                            if (object instanceof IRetentionIndexEntry) {
                                IRetentionIndexEntry retentionIndexEntry = (IRetentionIndexEntry)object;
                                keysToRemove.add(retentionIndexEntry.getRetentionTime());
                            }
                            ++n2;
                        }
                        Iterator iterator = keysToRemove.iterator();
                        while (iterator.hasNext()) {
                            int key = (Integer)iterator.next();
                            RetentionIndexUI.this.separationColumnIndices.remove((Object)key);
                        }
                        RetentionIndexUI.this.retentionIndexListUI.setInput(RetentionIndexUI.this.separationColumnIndices);
                        RetentionIndexUI.this.fireUpdate();
                    }
                }
            }

            @Override
            public void add(IRetentionIndexEntry retentionIndexEntry) {
                if (retentionIndexEntry != null && RetentionIndexUI.this.separationColumnIndices != null) {
                    RetentionIndexUI.this.separationColumnIndices.put(retentionIndexEntry);
                    RetentionIndexUI.this.retentionIndexListUI.setInput(RetentionIndexUI.this.separationColumnIndices);
                    RetentionIndexUI.this.fireUpdate();
                }
            }
        });
        return calibrationEditUI;
    }

    private RetentionIndexTableViewerUI createTableField(Composite composite) {
        RetentionIndexTableViewerUI tableViewer = new RetentionIndexTableViewerUI(composite, 2818);
        tableViewer.getTable().setLayoutData((Object)new GridData(1808));
        tableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetentionIndexUI.this.calibrationEditUI.selectRetentionIndices();
                RetentionIndexUI.this.fireUpdate();
            }
        });
        return tableViewer;
    }

    private void fireUpdate() {
        if (this.updateListener != null) {
            this.updateListener.update();
        }
    }
}

