/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.editors;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.converter.exceptions.NoChromatogramConverterAvailableException;
import org.eclipse.chemclipse.csd.converter.chromatogram.ChromatogramConverterCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.selection.ChromatogramSelectionCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IMeasurementResult;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.IChromatogramSelectionProcessSupplier;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.ProcessorFactory;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.processing.methods.IProcessMethod;
import org.eclipse.chemclipse.processing.methods.ProcessEntryContainer;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionConsumer;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionContext;
import org.eclipse.chemclipse.processing.supplier.ProcessSupplierContext;
import org.eclipse.chemclipse.support.settings.UserManagement;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.support.ui.workbench.PartSupport;
import org.eclipse.chemclipse.ux.extension.ui.editors.IChromatogramEditor;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.charts.ChromatogramChart;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.editors.ChromatogramFileSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.runnables.ChromatogramImportRunnable;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.AbstractDataUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.IDataUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.MeasurementResultNotification;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.ObjectChangedListener;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.ProcessMethodNotifications;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ChromatogramDataSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors.ExtendedChromatogramUI;
import org.eclipse.chemclipse.wsd.converter.chromatogram.ChromatogramConverterWSD;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.ChromatogramSelectionWSD;
import org.eclipse.chemclipse.xxd.process.support.ProcessTypeSupport;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.ICustomPaintListener;

public abstract class AbstractChromatogramEditor
extends AbstractDataUpdateSupport
implements IChromatogramEditor,
IDataUpdateSupport {
    public static final String ICON_URI = "platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/chromatogram.gif";
    public static final String TOOLTIP = "Chromatogram Editor";
    private static final Logger logger = Logger.getLogger(AbstractChromatogramEditor.class);
    private final DataType dataType;
    private final MPart part;
    private final MDirtyable dirtyable;
    private final IEventBroker eventBroker;
    private File chromatogramFile = null;
    private ExtendedChromatogramUI extendedChromatogramUI;
    private final IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    private final Shell shell;
    private final ObjectChangedListener<Object> updateMenuListener = new ObjectChangedListener<Object>(){

        @Override
        public void objectChanged(ObjectChangedListener.ChangeType type, Object newObject, Object oldObject) {
            if (AbstractChromatogramEditor.this.extendedChromatogramUI != null) {
                AbstractChromatogramEditor.this.extendedChromatogramUI.updateMenu(true);
                AbstractChromatogramEditor.this.extendedChromatogramUI.updateMethods();
            }
        }
    };
    private final ObjectChangedListener<IMeasurementResult<?>> updateMeasurementResult = new MeasurementResultListener();
    private final ProcessSupplierContext processSupplierContext;

    @Deprecated
    public AbstractChromatogramEditor(DataType dataType, Composite parent, MPart part, MDirtyable dirtyable, ProcessorFactory filterFactory, Shell shell) {
        this(dataType, parent, part, dirtyable, (ProcessSupplierContext)new ProcessTypeSupport(), shell);
    }

    public AbstractChromatogramEditor(DataType dataType, Composite parent, MPart part, MDirtyable dirtyable, ProcessSupplierContext processSupplierContext, Shell shell) {
        super(part);
        this.dataType = dataType;
        this.part = part;
        this.dirtyable = dirtyable;
        this.processSupplierContext = processSupplierContext;
        this.eventBroker = Activator.getDefault().getEventBroker();
        this.shell = shell;
        this.initialize(parent);
    }

    @Override
    public void registerEvents() {
        this.registerEvent("chromatogram/msd/update/chromatogramselection", "ChromatogramSelection");
        this.registerEvent("chromatogram/csd/update/chromatogramselection", "ChromatogramSelection");
        this.registerEvent("chromatogram/wsd/update/chromatogramselection", "ChromatogramSelection");
        this.registerEvent("scan/xxd/update/selection", "org.eclipse.e4.data");
        this.registerEvent("scan/xxd/unload/selection", "org.eclipse.e4.data");
        this.registerEvent("peak/xxd/update/selection", "org.eclipse.e4.data");
        this.registerEvent("peak/xxd/unload/selection", "org.eclipse.e4.data");
    }

    @Focus
    public void onFocus() {
        if (this.shell != null) {
            this.extendedChromatogramUI.fireUpdate(this.shell.getDisplay());
        }
    }

    @Override
    public void updateObjects(List<Object> objects, String topic) {
        if (objects.size() == 1) {
            Object object = objects.get(0);
            if (object instanceof IChromatogramSelection) {
                IChromatogramSelection chromatogramSelection = (IChromatogramSelection)object;
                if (this.extendedChromatogramUI.isActiveChromatogramSelection(chromatogramSelection)) {
                    this.extendedChromatogramUI.update();
                }
            } else if (object instanceof IScan) {
                this.extendedChromatogramUI.updateSelectedScan();
            } else if (object instanceof IPeak) {
                this.extendedChromatogramUI.updateSelectedPeak();
            }
        }
    }

    @PostConstruct
    private void postConstruct(ProcessMethodNotifications methodNotification, MeasurementResultNotification measurementNotification) {
        methodNotification.addObjectChangedListener(this.updateMenuListener);
        measurementNotification.addObjectChangedListener(this.updateMeasurementResult);
    }

    @PreDestroy
    private void preDestroy(ProcessMethodNotifications notifications, MeasurementResultNotification measurementNotification, PartSupport partSupport) {
        notifications.removeObjectChangedListener(this.updateMenuListener);
        measurementNotification.removeObjectChangedListener(this.updateMeasurementResult);
        if (this.eventBroker != null) {
            DisplayUtils.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractChromatogramEditor.this.eventBroker.send("scan/xxd/unload/selection", null);
                }
            });
            DisplayUtils.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractChromatogramEditor.this.eventBroker.send("peak/xxd/unload/selection", null);
                }
            });
            DisplayUtils.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractChromatogramEditor.this.eventBroker.send("chromatogram/xxd/unload/chromatogramselection", null);
                }
            });
        }
        partSupport.closePart(this.part);
    }

    @Persist
    public void save() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.shell);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask("Save Chromatogram", -1);
                    try {
                        AbstractChromatogramEditor.this.saveChromatogram(monitor);
                    }
                    catch (NoChromatogramConverterAvailableException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            dialog.run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            this.saveAs();
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
    }

    public boolean saveAs() {
        boolean saveSuccessful = false;
        IChromatogramSelection chromatogramSelection = this.extendedChromatogramUI.getChromatogramSelection();
        if (chromatogramSelection != null) {
            try {
                String filterPath = this.getFilterPath();
                saveSuccessful = ChromatogramFileSupport.saveChromatogram(this.shell, chromatogramSelection.getChromatogram(), this.dataType, filterPath);
                this.dirtyable.setDirty(!saveSuccessful);
            }
            catch (Exception e) {
                logger.warn((Object)e);
            }
        }
        return saveSuccessful;
    }

    public IChromatogramSelection getChromatogramSelection() {
        return this.extendedChromatogramUI.getChromatogramSelection();
    }

    private String getFilterPath() {
        String filterPath = this.preferenceStore.getString("chromatogramSaveAsFolder");
        if ("".equals(filterPath)) {
            filterPath = this.chromatogramFile != null ? (this.chromatogramFile.isDirectory() ? this.chromatogramFile.getAbsolutePath() : this.chromatogramFile.getParentFile().getAbsolutePath()) : UserManagement.getUserHome();
        }
        return filterPath;
    }

    private synchronized void initialize(Composite parent) {
        IChromatogramSelection chromatogramSelection = this.loadChromatogram();
        this.createEditorPages(parent);
        this.extendedChromatogramUI.updateChromatogramSelection(chromatogramSelection);
        this.processChromatogram(chromatogramSelection);
        if (chromatogramSelection != null) {
            this.part.setLabel(ChromatogramDataSupport.getChromatogramEditorLabel(chromatogramSelection));
            this.dirtyable.setDirty(true);
            chromatogramSelection.update(true);
        }
    }

    private void processChromatogram(final IChromatogramSelection chromatogramSelection) {
        final File file = new File(this.preferenceStore.getString("chromatogramLoadProcessMethod"));
        if (chromatogramSelection != null && file != null) {
            try {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.shell);
                dialog.run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        IProcessMethod processMethod = (IProcessMethod)Adapters.adapt((Object)file, IProcessMethod.class);
                        if (processMethod != null) {
                            ProcessEntryContainer.applyProcessEntries((ProcessEntryContainer)processMethod, (ProcessExecutionContext)new ProcessExecutionContext(monitor, (MessageConsumer)new ProcessingInfo(), AbstractChromatogramEditor.this.processSupplierContext), (ProcessExecutionConsumer)IChromatogramSelectionProcessSupplier.createConsumer((IChromatogramSelection)chromatogramSelection));
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                logger.warn((Object)e);
            }
            catch (InterruptedException e) {
                logger.warn((Object)e);
            }
        }
    }

    private synchronized IChromatogramSelection loadChromatogram() {
        ChromatogramSelectionMSD chromatogramSelection = null;
        try {
            Object object = this.part.getObject();
            if (object instanceof Map) {
                Map map = (Map)object;
                File file = new File((String)map.get("File"));
                boolean batch = (Boolean)map.get("Batch");
                chromatogramSelection = this.loadChromatogramSelection(file, batch);
            } else {
                if (object instanceof IChromatogramMSD) {
                    IChromatogramMSD chromatogram = (IChromatogramMSD)object;
                    chromatogramSelection = new ChromatogramSelectionMSD(chromatogram);
                } else if (object instanceof IChromatogramCSD) {
                    IChromatogramCSD chromatogram = (IChromatogramCSD)object;
                    chromatogramSelection = new ChromatogramSelectionCSD(chromatogram);
                } else if (object instanceof IChromatogramWSD) {
                    IChromatogramWSD chromatogram = (IChromatogramWSD)object;
                    chromatogramSelection = new ChromatogramSelectionWSD(chromatogram);
                }
                this.chromatogramFile = null;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return chromatogramSelection;
    }

    private synchronized IChromatogramSelection loadChromatogramSelection(File file, boolean batch) throws FileNotFoundException, NoChromatogramConverterAvailableException, FileIsNotReadableException, FileIsEmptyException, ChromatogramIsNullException {
        IChromatogramSelection chromatogramSelection = null;
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.shell);
        ChromatogramImportRunnable runnable = new ChromatogramImportRunnable(file, this.dataType);
        try {
            boolean fork = !batch;
            dialog.run(fork, false, (IRunnableWithProgress)runnable);
            chromatogramSelection = runnable.getChromatogramSelection();
            this.chromatogramFile = file;
        }
        catch (Exception e) {
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return chromatogramSelection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveChromatogram(IProgressMonitor monitor) throws NoChromatogramConverterAvailableException {
        IChromatogramSelection chromatogramSelection = this.extendedChromatogramUI.getChromatogramSelection();
        if (chromatogramSelection == null || this.shell == null) return;
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        String converterId = chromatogram.getConverterId();
        if (converterId == null || converterId.equals("") || this.chromatogramFile == null) throw new NoChromatogramConverterAvailableException();
        monitor.subTask("Save Chromatogram");
        IProcessingInfo processingInfo = null;
        if (chromatogram instanceof IChromatogramMSD) {
            IChromatogramMSD chromatogramMSD = (IChromatogramMSD)chromatogram;
            processingInfo = ChromatogramConverterMSD.getInstance().convert(this.chromatogramFile, (IChromatogram)chromatogramMSD, converterId, monitor);
        } else if (chromatogram instanceof IChromatogramCSD) {
            IChromatogramCSD chromatogramCSD = (IChromatogramCSD)chromatogram;
            processingInfo = ChromatogramConverterCSD.getInstance().convert(this.chromatogramFile, (IChromatogram)chromatogramCSD, converterId, monitor);
        } else if (chromatogram instanceof IChromatogramWSD) {
            IChromatogramWSD chromatogramWSD = (IChromatogramWSD)chromatogram;
            processingInfo = ChromatogramConverterWSD.getInstance().convert(this.chromatogramFile, (IChromatogram)chromatogramWSD, converterId, monitor);
        }
        if (processingInfo == null) throw new NoChromatogramConverterAvailableException();
        Object object = processingInfo.getProcessingResult();
        if (!(object instanceof File)) return;
        this.dirtyable.setDirty(false);
    }

    private void createEditorPages(Composite parent) {
        this.createChromatogramPage(parent);
    }

    private void createChromatogramPage(Composite parent) {
        this.extendedChromatogramUI = new ExtendedChromatogramUI(parent, 2048, this.eventBroker, this.processSupplierContext);
    }

    private final class MeasurementResultListener
    implements ObjectChangedListener<IMeasurementResult<?>>,
    Observer {
        private ICustomPaintListener oldPaintListener;
        private Observable oldObserver;

        private MeasurementResultListener() {
        }

        @Override
        public void objectChanged(ObjectChangedListener.ChangeType type, IMeasurementResult<?> newObject, IMeasurementResult<?> oldObject) {
            if (type == ObjectChangedListener.ChangeType.SELECTED) {
                Observable observable;
                ICustomPaintListener paintListener;
                boolean mustRedraw = false;
                if (this.oldPaintListener != null) {
                    AbstractChromatogramEditor.this.extendedChromatogramUI.getChromatogramChart().getBaseChart().getPlotArea().removeCustomPaintListener(this.oldPaintListener);
                    mustRedraw = true;
                    this.oldPaintListener = null;
                }
                if (this.oldObserver != null) {
                    this.oldObserver.deleteObserver(this);
                    this.oldObserver = null;
                }
                if ((paintListener = (ICustomPaintListener)Adapters.adapt(newObject, ICustomPaintListener.class)) != null) {
                    this.oldPaintListener = paintListener;
                    AbstractChromatogramEditor.this.extendedChromatogramUI.getChromatogramChart().getBaseChart().getPlotArea().addCustomPaintListener(paintListener);
                    mustRedraw = true;
                }
                if ((observable = (Observable)Adapters.adapt(newObject, Observable.class)) != null) {
                    this.oldObserver = observable;
                    observable.addObserver(this);
                }
                if (mustRedraw) {
                    Display.getDefault().asyncExec(this::redraw);
                }
            }
        }

        @Override
        public void update(Observable o, Object arg) {
            Display.getDefault().asyncExec(this::redraw);
        }

        private void redraw() {
            ChromatogramChart chart = AbstractChromatogramEditor.this.extendedChromatogramUI.getChromatogramChart();
            if (!chart.isDisposed()) {
                chart.redraw();
            }
        }
    }
}

