/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.editors;

import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IMeasurement;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.IChromatogramSelectionProcessSupplier;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.supplier.AbstractProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionContext;
import org.eclipse.chemclipse.processing.supplier.ProcessSupplierFactory;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.SupplierEditorSupport;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.UISynchronize;
import org.osgi.service.component.annotations.Component;

@Component(service={IProcessTypeSupplier.class})
public class EditorProcessTypeSupplier
implements IProcessTypeSupplier {
    public String getCategory() {
        return "User Interface";
    }

    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        return Collections.singleton(new OpenEditorSupplier(this));
    }

    private static final class OpenEditorSupplier
    extends AbstractProcessSupplier<Void>
    implements IChromatogramSelectionProcessSupplier<Void> {
        @Inject
        IEclipseContext eclipseContext;
        @Inject
        UISynchronize ui;

        public OpenEditorSupplier(IProcessTypeSupplier parent) {
            super("org.eclipse.chemclipse.ux.extension.xxd.ui.editors.EditorProcessTypeSupplier.OpenEditorSupplier", "Open Editor", "Opens an editor with the given dataset", null, parent, new DataCategory[]{DataCategory.MSD, DataCategory.CSD, DataCategory.WSD});
        }

        public IChromatogramSelection<?, ?> apply(final IChromatogramSelection<?, ?> chromatogramSelection, Void processSettings, ProcessExecutionContext context) {
            if (this.eclipseContext == null) {
                context.addErrorMessage(this.getName(), "This supplier requires ContextInjection to work properly");
            } else {
                this.ui.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
                        if (chromatogram instanceof IChromatogramMSD) {
                            new SupplierEditorSupport(DataType.MSD, () -> eclipseContext).openEditor((IMeasurement)chromatogram);
                        } else if (chromatogram instanceof IChromatogramWSD) {
                            new SupplierEditorSupport(DataType.WSD, () -> eclipseContext).openEditor((IMeasurement)chromatogram);
                        } else if (chromatogram instanceof IChromatogramCSD) {
                            new SupplierEditorSupport(DataType.CSD, () -> eclipseContext).openEditor((IMeasurement)chromatogram);
                        }
                    }
                });
            }
            return chromatogramSelection;
        }

        @ProcessSupplierFactory
        public OpenEditorSupplier createInjectionInstance() {
            return new OpenEditorSupplier(this.getTypeSupplier());
        }
    }
}

