/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.editors;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.pcr.model.core.IPlate;
import org.eclipse.chemclipse.support.ui.addons.ModelSupportAddon;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.ux.extension.ui.editors.IChemClipseEditor;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.editors.PCRFileSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.runnables.PCRImportRunnable;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.AbstractDataUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.IDataUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors.ExtendedPCRPlateUI;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class PlateEditorPCR
extends AbstractDataUpdateSupport
implements IChemClipseEditor,
IDataUpdateSupport {
    private static final Logger logger = Logger.getLogger(PlateEditorPCR.class);
    public static final String ID = "org.eclipse.chemclipse.ux.extension.xxd.ui.part.plateEditorPCR";
    public static final String CONTRIBUTION_URI = "bundleclass://org.eclipse.chemclipse.ux.extension.xxd.ui/org.eclipse.chemclipse.ux.extension.xxd.ui.editors.PlateEditorPCR";
    public static final String ICON_URI = "platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/plate-pcr.gif";
    public static final String TOOLTIP = "PCR Editor";
    private final MPart part;
    private final MDirtyable dirtyable;
    private File plateFile;
    private IPlate plate = null;
    private ExtendedPCRPlateUI extendedPCRPlateUI;
    private final Shell shell;

    @Inject
    public PlateEditorPCR(Composite parent, MPart part, MDirtyable dirtyable, Shell shell) {
        super(part);
        this.part = part;
        this.dirtyable = dirtyable;
        this.shell = shell;
        this.initialize(parent);
    }

    @Override
    public void registerEvents() {
    }

    @Override
    public void updateObjects(List<Object> objects, String topic) {
        objects.size();
    }

    @Focus
    public void setFocus() {
        this.updatePlate();
    }

    @Override
    @PreDestroy
    protected void preDestroy() {
        super.preDestroy();
        this.unloadPlate();
        EModelService modelService = ModelSupportAddon.getModelService();
        if (modelService != null) {
            MApplication application = ModelSupportAddon.getApplication();
            final MPartStack partStack = (MPartStack)modelService.find("org.eclipse.e4.primaryDataStack", (MUIElement)application);
            this.part.setToBeRendered(false);
            this.part.setVisible(false);
            DisplayUtils.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    partStack.getChildren().remove(PlateEditorPCR.this.part);
                }
            });
        }
        System.gc();
    }

    @Persist
    public void save() {
        System.out.println("Plate File: " + this.plateFile);
        this.saveAs();
    }

    public boolean saveAs() {
        boolean saveSuccessful = false;
        if (this.plate != null) {
            try {
                saveSuccessful = PCRFileSupport.savePlate(this.shell, this.plate);
                this.dirtyable.setDirty(!saveSuccessful);
            }
            catch (Exception e) {
                logger.warn((Object)e);
            }
        }
        return saveSuccessful;
    }

    private void initialize(Composite parent) {
        this.createEditorPages(parent);
        this.plate = this.loadPlate();
        this.extendedPCRPlateUI.update(this.plate);
    }

    private synchronized IPlate loadPlate() {
        IPlate plate = null;
        Object object = this.part.getObject();
        if (object instanceof Map) {
            Map map = (Map)object;
            File file = new File((String)map.get("File"));
            boolean batch = (Boolean)map.get("Batch");
            plate = this.loadPlate(file, batch);
        }
        return plate;
    }

    private IPlate loadPlate(File file, boolean batch) {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.shell);
        PCRImportRunnable runnable = new PCRImportRunnable(file);
        try {
            boolean fork = !batch;
            dialog.run(fork, false, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)e);
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
        this.plateFile = file;
        return runnable.getPlate();
    }

    private void createEditorPages(Composite parent) {
        this.createScanPage(parent);
    }

    private void createScanPage(Composite parent) {
        this.extendedPCRPlateUI = new ExtendedPCRPlateUI(parent);
    }

    private void updatePlate() {
        this.extendedPCRPlateUI.update(this.plate);
        final IEventBroker eventBroker = ModelSupportAddon.getEventBroker();
        DisplayUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                eventBroker.send("plate/pcr/update/selection", (Object)PlateEditorPCR.this.plate);
            }
        });
    }

    private void unloadPlate() {
        final IEventBroker eventBroker = ModelSupportAddon.getEventBroker();
        DisplayUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                eventBroker.send("plate/pcr/unload/selection", null);
            }
        });
    }
}

