/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.handlers;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ChromatogramDataSupport;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class DeleteNonQuantifiedPeaksHandler
implements EventHandler {
    private static IChromatogramSelection chromatogramSelection;
    private ChromatogramDataSupport chromatogramDataSupport = new ChromatogramDataSupport();

    @Execute
    public void execute(UISynchronize uiSynchronize, @Named(value="activeShell") Shell shell) {
        IChromatogram chromatogram;
        if (chromatogramSelection != null && (chromatogram = chromatogramSelection.getChromatogram()) != null) {
            MessageBox messageBox = new MessageBox(shell, 456);
            messageBox.setText("Delete Non Quantified Peaks");
            messageBox.setMessage("Do you really want to delete all non quantified peaks?");
            int decision = messageBox.open();
            if (64 == decision) {
                this.deleteNonQuantifiedPeaks(chromatogram);
                chromatogramSelection.update(true);
            }
        }
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("chromatogram/msd/update/chromatogramselection")) {
            chromatogramSelection = (IChromatogramSelection)event.getProperty("ChromatogramSelection");
        } else if (event.getTopic().equals("chromatogram/csd/update/chromatogramselection")) {
            chromatogramSelection = (IChromatogramSelection)event.getProperty("ChromatogramSelection");
        } else if (event.getTopic().equals("chromatogram/wsd/update/chromatogramselection")) {
            chromatogramSelection = (IChromatogramSelection)event.getProperty("ChromatogramSelection");
        }
    }

    private void deleteNonQuantifiedPeaks(IChromatogram chromatogram) {
        List<IPeak> peaks = ChromatogramDataSupport.getPeaks(chromatogram);
        ArrayList<IPeak> peaksToDelete = new ArrayList<IPeak>();
        for (IPeak peak : peaks) {
            if (peak.getQuantitationEntries().size() != 0) continue;
            peaksToDelete.add(peak);
        }
        if (chromatogram instanceof IChromatogramMSD) {
            IChromatogramMSD chromatogramMSD = (IChromatogramMSD)chromatogram;
            for (IPeak peak : peaksToDelete) {
                if (!(peak instanceof IChromatogramPeakMSD)) continue;
                chromatogramMSD.removePeak((IPeak)((IChromatogramPeakMSD)peak));
            }
        } else if (chromatogram instanceof IChromatogramCSD) {
            IChromatogramCSD chromatogramCSD = (IChromatogramCSD)chromatogram;
            for (IPeak peak : peaksToDelete) {
                if (!(peak instanceof IChromatogramPeakCSD)) continue;
                chromatogramCSD.removePeak((IPeak)((IChromatogramPeakCSD)peak));
            }
        } else {
            boolean cfr_ignored_0 = chromatogram instanceof IChromatogramWSD;
        }
    }
}

