/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import java.util.Collection;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.support.LibraryInformationSupport;
import org.eclipse.chemclipse.model.targets.ITarget;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class PeakScanListFilter
extends ViewerFilter {
    private String searchText;
    private boolean caseSensitive;
    private final LibraryInformationSupport libraryInformationSupport = new LibraryInformationSupport();

    public void setSearchText(String searchText, boolean caseSensitive) {
        this.searchText = ".*" + searchText + ".*";
        this.caseSensitive = caseSensitive;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.searchText == null || this.searchText.equals("")) {
            return true;
        }
        if (element instanceof IPeak || element instanceof IScan) {
            if (element instanceof IPeak) {
                IPeak peak = (IPeak)element;
                return this.matchPeak(peak);
            }
            if (element instanceof IScan) {
                IScan scan = (IScan)element;
                return this.matchScan(scan);
            }
        }
        return false;
    }

    private boolean matchPeak(IPeak peak) {
        if (this.isMatch(peak, this.searchText, this.caseSensitive)) {
            return true;
        }
        for (ITarget target : peak.getTargets()) {
            IIdentificationTarget identificationTarget;
            if (!(target instanceof IIdentificationTarget) || !this.libraryInformationSupport.matchSearchText((identificationTarget = (IIdentificationTarget)target).getLibraryInformation(), this.searchText, this.caseSensitive)) continue;
            return true;
        }
        return false;
    }

    private boolean matchScan(IScan scan) {
        for (IIdentificationTarget target : scan.getTargets()) {
            if (!this.libraryInformationSupport.matchSearchText(target.getLibraryInformation(), this.searchText, this.caseSensitive)) continue;
            return true;
        }
        return false;
    }

    private boolean isMatch(IPeak peak, String searchText, boolean caseSensitive) {
        boolean isMatch = false;
        Collection classifier = peak.getClassifier();
        String detectorDescription = peak.getDetectorDescription();
        String modelDescription = peak.getModelDescription();
        String quantifierDescription = peak.getQuantifierDescription();
        if (!caseSensitive) {
            searchText = searchText.toLowerCase();
            detectorDescription = detectorDescription.toLowerCase();
            modelDescription = modelDescription.toLowerCase();
            quantifierDescription = quantifierDescription.toLowerCase();
        }
        if (!isMatch && PeakScanListFilter.matchText(classifier, searchText, caseSensitive)) {
            isMatch = true;
        }
        if (!isMatch && detectorDescription.matches(searchText)) {
            isMatch = true;
        }
        if (!isMatch && modelDescription.matches(searchText)) {
            isMatch = true;
        }
        if (!isMatch && quantifierDescription.matches(searchText)) {
            isMatch = true;
        }
        return isMatch;
    }

    private static boolean matchText(Collection<String> classifier, String searchText, boolean caseSensitive) {
        for (String c : classifier) {
            if (!caseSensitive) {
                c = c.toLowerCase();
            }
            if (!PeakScanListFilter.matchText(c, searchText)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchText(String text, String searchText) {
        return text.matches(searchText);
    }
}

