/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import org.eclipse.chemclipse.model.quantitation.IQuantitationSignal;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class QuantSignalsEditingSupport
extends EditingSupport {
    private CellEditor cellEditor;
    private ExtendedTableViewer tableViewer;
    private String column;

    public QuantSignalsEditingSupport(ExtendedTableViewer tableViewer, String column) {
        super((ColumnViewer)tableViewer);
        this.column = column;
        this.cellEditor = column.equals("Use") ? new CheckboxCellEditor((Composite)tableViewer.getTable()) : new TextCellEditor((Composite)tableViewer.getTable());
        this.tableViewer = tableViewer;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.cellEditor;
    }

    protected boolean canEdit(Object element) {
        return this.tableViewer.isEditEnabled();
    }

    protected Object getValue(Object element) {
        block13: {
            if (!(element instanceof IQuantitationSignal)) break block13;
            IQuantitationSignal signal = (IQuantitationSignal)element;
            switch (this.column) {
                case "Relative Response": {
                    return Double.toString(signal.getRelativeResponse());
                }
                case "Uncertainty": {
                    return Double.toString(signal.getUncertainty());
                }
                case "Use": {
                    return signal.isUse();
                }
            }
        }
        return false;
    }

    protected void setValue(Object element, Object value) {
        block13: {
            if (!(element instanceof IQuantitationSignal)) break block13;
            IQuantitationSignal signal = (IQuantitationSignal)element;
            switch (this.column) {
                case "Relative Response": {
                    double relativeResponse = this.getValue(value, -1.0);
                    if (!(relativeResponse >= 0.0)) break;
                    signal.setRelativeResponse(relativeResponse);
                    break;
                }
                case "Uncertainty": {
                    double uncertainty = this.getValue(value, -1.0);
                    if (!(uncertainty >= 0.0)) break;
                    signal.setUncertainty(uncertainty);
                    break;
                }
                case "Use": {
                    signal.setUse(((Boolean)value).booleanValue());
                }
            }
            this.tableViewer.refresh();
        }
    }

    private double getValue(Object value, double def) {
        double result = def;
        if (value instanceof String) {
            try {
                result = Double.parseDouble((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }
}

