/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import java.io.File;
import java.text.DecimalFormat;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.swt.graphics.Image;

public class SequenceFilesLabelProvider
extends AbstractChemClipseLabelProvider {
    public static final String NAME = "Name";
    public static final String SIZE = "Size (KB)";
    public static String[] TITLES = new String[]{"Name", "Size (KB)"};
    public static int[] BOUNDS = new int[]{300, 60};

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        String text = "";
        if (element instanceof File) {
            File file = (File)element;
            switch (columnIndex) {
                case 0: {
                    text = file.getName();
                    break;
                }
                case 1: {
                    text = decimalFormat.format((double)file.length() / 1000.0);
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/sequenceListDefault.gif", "16x16");
    }
}

