/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.support;

import java.util.List;
import java.util.Optional;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.exceptions.NoExtractedIonSignalStoredException;
import org.eclipse.chemclipse.msd.model.xic.ExtractedIonSignalExtractor;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignals;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.support.ChromatogramHeatmapData;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.xwc.ExtractedSingleWavelengthSignalExtractor;
import org.eclipse.chemclipse.wsd.model.xwc.IExtractedSingleWavelengthSignals;
import org.eclipse.nebula.visualization.widgets.datadefinition.FloatArrayWrapper;
import org.eclipse.nebula.visualization.widgets.datadefinition.IPrimaryArrayWrapper;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;

public class ChromatogramHeatmapSupport {
    public Optional<ChromatogramHeatmapData> getHeatmap(IChromatogram chromatogram) {
        if (chromatogram instanceof IChromatogramMSD) {
            return this.getHeatmap((IChromatogramMSD)chromatogram);
        }
        if (chromatogram instanceof IChromatogramWSD) {
            return this.getHeatmap((IChromatogramWSD)chromatogram);
        }
        return Optional.empty();
    }

    public Optional<ChromatogramHeatmapData> getHeatmap(IChromatogramWSD chromatogram) {
        ExtractedSingleWavelengthSignalExtractor extractor = new ExtractedSingleWavelengthSignalExtractor(chromatogram, true);
        List signals = extractor.getExtractedWavelengthSignals();
        if (signals.size() >= 2) {
            double startWavelength = ((IExtractedSingleWavelengthSignals)signals.get(0)).getWavelength();
            double stopWavelength = ((IExtractedSingleWavelengthSignals)signals.get(signals.size() - 1)).getWavelength();
            int startScan = 1;
            int stopScan = chromatogram.getNumberOfScans();
            int dataHeight = signals.size();
            int dataWidth = stopScan - startScan + 1;
            double startRetentionTime = (double)chromatogram.getStartRetentionTime() / 60000.0;
            double stopRetentionTime = (double)chromatogram.getStopRetentionTime() / 60000.0;
            float[] heatmapData = new float[dataHeight * dataWidth * 2];
            int j = 0;
            int signalNumber = signals.size() - 1;
            while (signalNumber >= 0) {
                IExtractedSingleWavelengthSignals signal = (IExtractedSingleWavelengthSignals)signals.get(signalNumber);
                int scan = startScan;
                while (scan <= stopScan) {
                    int i = Math.min(Math.max(signal.getStartScan(), scan), signal.getStopScan());
                    heatmapData[j] = signal.getTotalScanSignal(i).getTotalSignal();
                    ++j;
                    ++scan;
                }
                --signalNumber;
            }
            float maxAbudance = -3.4028235E38f;
            float minAbudance = Float.MAX_VALUE;
            float[] fArray = heatmapData;
            int n = heatmapData.length;
            int n2 = 0;
            while (n2 < n) {
                float f = fArray[n2];
                maxAbudance = Float.max(maxAbudance, f);
                minAbudance = Float.min(minAbudance, f);
                ++n2;
            }
            return Optional.of(new ChromatogramHeatmapData((IPrimaryArrayWrapper)new FloatArrayWrapper(heatmapData), new Range(startRetentionTime, stopRetentionTime), new Range(startWavelength, stopWavelength), minAbudance, maxAbudance, dataWidth, dataHeight));
        }
        return Optional.empty();
    }

    public Optional<ChromatogramHeatmapData> getHeatmap(IChromatogramMSD chromatogram) {
        ExtractedIonSignalExtractor extractedIonSignalExtractor = new ExtractedIonSignalExtractor(chromatogram);
        IExtractedIonSignals extractedIonSignals = extractedIonSignalExtractor.getExtractedIonSignals();
        int startScan = extractedIonSignals.getStartScan();
        int stopScan = extractedIonSignals.getStopScan();
        int startIon = extractedIonSignals.getStartIon();
        int stopIon = extractedIonSignals.getStopIon();
        int dataWidth = stopScan - startScan + 1;
        int dataHeight = stopIon - startIon + 1;
        double startRetentionTime = (double)chromatogram.getStartRetentionTime() / 60000.0;
        double stopRetentionTime = (double)chromatogram.getStopRetentionTime() / 60000.0;
        if (dataHeight <= 1 || dataWidth <= 1) {
            return Optional.empty();
        }
        float[] heatmapData = new float[dataWidth * dataHeight * 2];
        int i = 0;
        int ion = stopIon;
        while (ion >= startIon) {
            int scan = startScan;
            while (scan <= stopScan) {
                try {
                    IExtractedIonSignal extractedIonSignal = extractedIonSignals.getExtractedIonSignal(scan);
                    heatmapData[i] = extractedIonSignal.getAbundance(ion);
                }
                catch (NoExtractedIonSignalStoredException e) {
                    heatmapData[i] = 0.0f;
                }
                ++i;
                ++scan;
            }
            --ion;
        }
        float maxAbudance = -3.4028235E38f;
        float minAbudance = Float.MAX_VALUE;
        float[] fArray = heatmapData;
        int n = heatmapData.length;
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[n2];
            maxAbudance = Float.max(maxAbudance, f);
            minAbudance = Float.min(minAbudance, f);
            ++n2;
        }
        maxAbudance = (float)((double)maxAbudance / ((double)dataWidth / 5.0));
        return Optional.of(new ChromatogramHeatmapData((IPrimaryArrayWrapper)new FloatArrayWrapper(heatmapData), new Range(startRetentionTime, stopRetentionTime), new Range((double)startIon, (double)stopIon), minAbudance, maxAbudance, dataWidth, dataHeight));
    }
}

