/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.methods;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.support.settings.ComboSettingsProperty;
import org.eclipse.chemclipse.support.settings.FileSettingProperty;
import org.eclipse.chemclipse.support.settings.parser.InputValue;
import org.eclipse.chemclipse.support.settings.validation.InputValidator;
import org.eclipse.chemclipse.support.ui.provider.AbstractLabelProvider;
import org.eclipse.chemclipse.support.ui.provider.AdapterLabelProvider;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class WidgetItem {
    private final InputValue inputValue;
    private InputValidator inputValidator;
    private ControlDecoration controlDecoration;
    private Control control;
    private Object currentSelection;

    public WidgetItem(InputValue inputValue, Object currentSelection) {
        this.inputValue = inputValue;
        this.currentSelection = currentSelection;
    }

    public InputValue getInputValue() {
        return this.inputValue;
    }

    public ControlDecoration getControlDecoration() {
        return this.controlDecoration;
    }

    public Control getControl() {
        return this.control;
    }

    public void initializeControl(Composite parent) {
        this.control = this.createControl(parent);
        this.inputValidator = new InputValidator(this.inputValue);
        this.controlDecoration = new ControlDecoration(this.control, 16512);
    }

    public IStatus validate() {
        IStatus status = this.getStatus();
        if (status.isOK()) {
            this.controlDecoration.hide();
        } else {
            this.controlDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
            this.controlDecoration.showHoverText(status.getMessage());
            this.controlDecoration.show();
        }
        return status;
    }

    private IStatus getStatus() {
        Object currentValue;
        try {
            currentValue = this.getValue();
        }
        catch (RuntimeException e) {
            currentValue = null;
        }
        for (IValidator validator : this.inputValue.getValidators()) {
            IStatus validate = validator.validate(currentValue);
            if (validate.isOK()) continue;
            return validate;
        }
        return this.inputValidator.validate(currentValue);
    }

    public Object getValue() {
        Class rawType = this.inputValue.getRawType();
        if (rawType != null) {
            if (rawType == File.class) {
                return this.currentSelection;
            }
            if (this.control instanceof Text) {
                Text text = (Text)this.control;
                String textValue = text.getText().trim();
                if (rawType == Long.TYPE || rawType == Long.class) {
                    if (textValue.isEmpty()) {
                        return 0;
                    }
                    return Long.parseLong(textValue);
                }
                if (rawType == Integer.TYPE || rawType == Integer.class) {
                    if (textValue.isEmpty()) {
                        return 0;
                    }
                    return Integer.parseInt(textValue);
                }
                if (rawType == Float.TYPE || rawType == Float.class) {
                    if (textValue.isEmpty()) {
                        return Float.valueOf(0.0f);
                    }
                    return Float.valueOf(Float.parseFloat(textValue));
                }
                if (rawType == Double.TYPE || rawType == Double.class) {
                    if (textValue.isEmpty()) {
                        return 0.0;
                    }
                    return Double.parseDouble(textValue);
                }
                return textValue;
            }
            if (this.control instanceof Button) {
                Button button = (Button)this.control;
                return button.getSelection();
            }
            if (this.control instanceof Combo) {
                ComboSettingsProperty.ComboSupplier comboSupplier = this.inputValue.getComboSupplier();
                if (comboSupplier != null) {
                    return this.getValueAsString(comboSupplier);
                }
                Combo combo = (Combo)this.control;
                if (rawType.isEnum()) {
                    return combo.getText().trim();
                }
            }
        }
        return null;
    }

    private <T> String getValueAsString(ComboSettingsProperty.ComboSupplier<T> comboSupplier) {
        try {
            return comboSupplier.asString(this.currentSelection);
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    private Control createControl(Composite parent) {
        Class rawType = this.inputValue.getRawType();
        if (rawType != null) {
            if (this.inputValue.getComboSupplier() != null) {
                ComboViewer viewer = this.createGenericCombo(parent, this.inputValue.getComboSupplier());
                return viewer.getControl();
            }
            if (rawType == Long.TYPE || rawType == Long.class) {
                return this.createTextWidgetNormal(parent);
            }
            if (rawType == Integer.TYPE || rawType == Integer.class) {
                return this.createTextWidgetNormal(parent);
            }
            if (rawType == Float.TYPE || rawType == Float.class) {
                return this.createTextWidgetNormal(parent);
            }
            if (rawType == Double.TYPE || rawType == Double.class) {
                return this.createTextWidgetNormal(parent);
            }
            if (rawType == String.class) {
                if (this.inputValue.isMultiLine()) {
                    return this.createTextWidgetMultiLine(parent);
                }
                return this.createTextWidgetNormal(parent);
            }
            if (rawType == Boolean.TYPE || rawType == Boolean.class) {
                return this.createCheckboxWidget(parent);
            }
            if (rawType.isEnum()) {
                ArrayList<String> input = new ArrayList<String>();
                Enum[] enums = (Enum[])rawType.getEnumConstants();
                int i = 0;
                while (i < enums.length) {
                    input.add(enums[i].toString());
                    ++i;
                }
                return this.createEnumComboViewerWidget(parent, input);
            }
            if (rawType == File.class) {
                return this.createFileWidget(parent);
            }
            Label label = new Label(parent, 0);
            label.setText("Unsupported Type: " + rawType);
            return label;
        }
        return null;
    }

    private ComboViewer createGenericCombo(Composite parent, ComboSettingsProperty.ComboSupplier<?> comboSupplier) {
        final ComboViewer comboViewer = new ComboViewer(parent, 8);
        Combo combo = comboViewer.getCombo();
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new AdapterLabelProvider());
        combo.setToolTipText(this.inputValue.getDescription());
        GridData gridData = new GridData(768);
        gridData.widthHint = 150;
        combo.setLayoutData((Object)gridData);
        comboViewer.setInput((Object)comboSupplier.items());
        if (this.currentSelection instanceof String) {
            Object currentValue = comboSupplier.fromString((String)this.currentSelection);
            if (currentValue != null) {
                comboViewer.setSelection((ISelection)new StructuredSelection(currentValue));
            } else {
                comboViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            this.currentSelection = currentValue;
        }
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WidgetItem.this.currentSelection = comboViewer.getStructuredSelection().getFirstElement();
            }
        });
        return comboViewer;
    }

    private Control createFileWidget(Composite parent) {
        final FileSettingProperty fileSettingProperty = this.inputValue.getFileSettingProperty();
        final Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        final CLabel label = new CLabel(composite, 0);
        label.setForeground(parent.getDisplay().getSystemColor(16));
        String value = this.getValueAsString();
        if (value == null || value.isEmpty()) {
            label.setText("Please choose a location ...");
        } else {
            label.setText(value);
        }
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        final Button button = new Button(composite, 8);
        button.setText(" ... ");
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Listener[] listeners;
                String open;
                FileDialog dialog;
                int style;
                boolean filechooser;
                if (fileSettingProperty != null) {
                    boolean bl = filechooser = !fileSettingProperty.onlyDirectory();
                    style = fileSettingProperty.dialogType() == FileSettingProperty.DialogType.OPEN_DIALOG ? 4096 : 8192;
                } else {
                    filechooser = true;
                    style = 4096;
                }
                if (filechooser) {
                    dialog = new FileDialog(button.getShell(), style);
                    if (fileSettingProperty != null) {
                        String[] extensions = fileSettingProperty.validExtensions();
                        String[] extensionNames = fileSettingProperty.extensionNames();
                        if (extensions.length > 0) {
                            dialog.setFilterExtensions(extensions);
                        }
                        if (extensionNames.length > 0) {
                            dialog.setFilterNames(extensionNames);
                        }
                    }
                    if ((open = dialog.open()) != null) {
                        label.setText(open);
                        WidgetItem.this.currentSelection = new File(open);
                    }
                } else {
                    dialog = new DirectoryDialog(button.getShell(), style);
                    open = dialog.open();
                    if (open != null) {
                        label.setText(open);
                        WidgetItem.this.currentSelection = new File(open);
                    }
                }
                Listener[] listenerArray = listeners = composite.getListeners(13);
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    Listener listener = listenerArray[n2];
                    listener.handleEvent(new Event());
                    ++n2;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return composite;
    }

    private Control createTextWidgetNormal(Composite parent) {
        return this.createTextWidget(parent, 2048, new GridData(768));
    }

    private Control createTextWidgetMultiLine(Composite parent) {
        return this.createTextWidget(parent, 2818, new GridData(1808));
    }

    private Control createTextWidget(Composite parent, int style, GridData gridData) {
        Text text = new Text(parent, style);
        text.setText(this.getValueAsString());
        text.setToolTipText(this.inputValue.getDescription());
        text.setLayoutData((Object)gridData);
        return text;
    }

    private Control createCheckboxWidget(Composite parent) {
        Button button = new Button(parent, 32);
        button.setText("");
        button.setSelection(this.getValueAsBoolean());
        button.setToolTipText(this.inputValue.getDescription());
        button.setLayoutData((Object)new GridData(768));
        return button;
    }

    private Control createEnumComboViewerWidget(Composite parent, List<String> input) {
        ComboViewer comboViewer = new ComboViewer(parent, 8);
        Combo combo = comboViewer.getCombo();
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                return element.toString();
            }
        });
        combo.setToolTipText(this.inputValue.getDescription());
        GridData gridData = new GridData(768);
        gridData.widthHint = 150;
        combo.setLayoutData((Object)gridData);
        comboViewer.setInput(input);
        combo.setText(this.getValueAsString());
        return combo;
    }

    private boolean getValueAsBoolean() {
        if (this.currentSelection instanceof Boolean) {
            return (Boolean)this.currentSelection;
        }
        if (this.currentSelection instanceof String) {
            return Boolean.valueOf((String)this.currentSelection);
        }
        return false;
    }

    private String getValueAsString() {
        if (this.currentSelection == null) {
            return "";
        }
        if (this.currentSelection instanceof String) {
            return (String)this.currentSelection;
        }
        return this.currentSelection.toString();
    }
}

