/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.identifier.ITargetTemplate;
import org.eclipse.chemclipse.model.identifier.TargetTemplate;
import org.eclipse.chemclipse.support.util.TargetListUtil;

public class TargetTemplates
extends HashMap<String, ITargetTemplate> {
    private static final long serialVersionUID = -439374805911311705L;
    private static final Logger logger = Logger.getLogger(TargetTemplates.class);
    private TargetListUtil targetListUtil = new TargetListUtil();

    public void add(ITargetTemplate targetTemplate) {
        if (targetTemplate != null) {
            this.put(targetTemplate.getName(), targetTemplate);
        }
    }

    public void load(String targetTemplates) {
        this.loadSettings(targetTemplates);
    }

    public void loadDefault(String targetTemplates) {
        this.loadSettings(targetTemplates);
    }

    public String save() {
        StringBuilder builder = new StringBuilder();
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            ITargetTemplate targetTemplate = (ITargetTemplate)iterator.next();
            this.extractTargetTemplate(targetTemplate, builder);
            if (!iterator.hasNext()) continue;
            builder.append(";");
        }
        return builder.toString().trim();
    }

    public void importItems(File file) {
        try {
            String line;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((line = bufferedReader.readLine()) != null) {
                ITargetTemplate template = this.extractTargetTemplate(line);
                if (template == null) continue;
                this.add(template);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e);
        }
        catch (IOException e) {
            logger.warn((Object)e);
        }
    }

    public boolean exportItems(File file) {
        try {
            PrintWriter printWriter = new PrintWriter(file);
            Iterator iterator = this.values().iterator();
            while (iterator.hasNext()) {
                StringBuilder builder = new StringBuilder();
                ITargetTemplate template = (ITargetTemplate)iterator.next();
                this.extractTargetTemplate(template, builder);
                printWriter.println(builder.toString());
            }
            printWriter.flush();
            printWriter.close();
            return true;
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e);
            return false;
        }
    }

    private void loadSettings(String targetTemplates) {
        String[] items;
        if (!"".equals(targetTemplates) && (items = this.targetListUtil.parseString(targetTemplates)).length > 0) {
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                ITargetTemplate targetTemplate = this.extractTargetTemplate(item);
                if (targetTemplate != null) {
                    this.add(targetTemplate);
                }
                ++n2;
            }
        }
    }

    public String extractTargetTemplate(ITargetTemplate targetTemplate) {
        StringBuilder builder = new StringBuilder();
        this.extractTargetTemplate(targetTemplate, builder);
        return builder.toString();
    }

    public ITargetTemplate extractTargetTemplate(String item) {
        TargetTemplate targetTemplate = null;
        if (!"".equals(item)) {
            String[] values = item.split("\\|");
            targetTemplate = new TargetTemplate();
            targetTemplate.setName(values.length > 0 ? values[0].trim() : "");
            targetTemplate.setCasNumber(values.length > 1 ? values[1].trim() : "");
            targetTemplate.setComments(values.length > 2 ? values[2].trim() : "");
            targetTemplate.setContributor(values.length > 3 ? values[3].trim() : "");
            targetTemplate.setReferenceId(values.length > 4 ? values[4].trim() : "");
        }
        return targetTemplate;
    }

    private void extractTargetTemplate(ITargetTemplate targetTemplate, StringBuilder builder) {
        builder.append(targetTemplate.getName());
        builder.append(" ");
        builder.append("|");
        builder.append(" ");
        builder.append(targetTemplate.getCasNumber());
        builder.append(" ");
        builder.append("|");
        builder.append(" ");
        builder.append(targetTemplate.getComments());
        builder.append(" ");
        builder.append("|");
        builder.append(" ");
        builder.append(targetTemplate.getContributor());
        builder.append(" ");
        builder.append("|");
        builder.append(" ");
        builder.append(targetTemplate.getReferenceId());
    }
}

