/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.parts;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.AbstractDataUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.IDataUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageTaskCombined;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageTaskComparison;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageTaskESTD;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageTaskHeatmaps;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageTaskISTD;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageTaskLists;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageTaskOverlay;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageTaskOverview;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageTaskPCR;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageTaskPeaks;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageTaskQuantitation;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageTaskResults;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageTaskScans;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageTaskSubtract;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageTasks;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TaskQuickAccessPart
extends AbstractDataUpdateSupport
implements IDataUpdateSupport {
    private final IPreferenceStore preferenceStore;
    private final EPartService partService;
    private final EModelService modelService;
    private final MApplication application;
    private final IEventBroker eventBroker;

    @Inject
    public TaskQuickAccessPart(Composite parent, MPart part, EPartService partService, EModelService modelService, MApplication application, IEventBroker eventBroker) {
        super(part);
        this.partService = partService;
        this.modelService = modelService;
        this.application = application;
        this.eventBroker = eventBroker;
        this.preferenceStore = Activator.getDefault().getPreferenceStore();
        this.initialize(parent);
    }

    @Focus
    public void setFocus() {
    }

    @Override
    public void registerEvents() {
        this.registerEvent("toggle/part/visibility/true", "org.eclipse.e4.data");
        this.registerEvent("toggle/part/visibility/false", "org.eclipse.e4.data");
    }

    @Override
    public void updateObjects(List<Object> objects, String topic) {
        Object object;
        if (objects.size() == 1 && (object = objects.get(0)) instanceof String) {
            String id = (String)object;
            if ("toggle/part/visibility/true".equals(topic)) {
                PartSupport.setButtonImage((String)id, (boolean)true);
            } else if ("toggle/part/visibility/false".equals(topic)) {
                PartSupport.setButtonImage((String)id, (boolean)false);
            }
        }
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new RowLayout());
        this.createOverviewTask(parent);
        this.createOverlayTask(parent);
        this.createScansTask(parent);
        this.createPeaksTask(parent);
        this.createListTask(parent);
        this.createQuantitationTask(parent);
        this.createInternalStandardsTask(parent);
        this.createExternalStandardsTask(parent);
        this.createSubtractScanTask(parent);
        this.createCombinedScanTask(parent);
        this.createComparisonScanTask(parent);
        this.createMeasurementResultTask(parent);
        this.createHeatmapTask(parent);
        this.createPcrTask(parent);
        this.createSettingsTask(parent);
        this.showInitialViews();
    }

    private void showInitialViews() {
        PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.targetsPartDescriptor", (String)this.preferenceStore.getString("stackPositionTargets"), (EPartService)this.partService, (EModelService)this.modelService, (MApplication)this.application, (IEventBroker)this.eventBroker);
        PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.scanChartPartDescriptor", (String)this.preferenceStore.getString("stackPositionScanChart"), (EPartService)this.partService, (EModelService)this.modelService, (MApplication)this.application, (IEventBroker)this.eventBroker);
        PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.scanTablePartDescriptor", (String)this.preferenceStore.getString("stackPositionScanTable"), (EPartService)this.partService, (EModelService)this.modelService, (MApplication)this.application, (IEventBroker)this.eventBroker);
        PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.scanBrowsePartDescriptor", (String)this.preferenceStore.getString("stackPositionScanBrowse"), (EPartService)this.partService, (EModelService)this.modelService, (MApplication)this.application, (IEventBroker)this.eventBroker);
    }

    private void createOverviewTask(Composite parent) {
        Image imageActive = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/chromatogramOverviewActive.gif", "16x16");
        Image imageDefault = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/chromatogramOverviewDefault.gif", "16x16");
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Toggle the overview modus");
        button.setImage(imageDefault);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.headerDataPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionMeasurementHeader"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.chromatogramOverviewPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionChromatogramOverview"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.partdescriptor.miscellaneousInfoPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionMiscellaneousInfo"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.partdescriptor.chromatogramScanInfoPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionChromatogramScanInfo"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
            }
        });
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.headerDataPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.chromatogramOverviewPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
    }

    private void createOverlayTask(Composite parent) {
        Image imageActive = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/chromatogramOverlayActive.gif", "16x16");
        Image imageDefault = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/chromatogramOverlayDefault.gif", "16x16");
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Toggle the overlay modus");
        button.setImage(imageDefault);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.chromatogramOverlayPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionOverlayChromatogramDefault"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.nmrOverlayPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionOverlayNMR"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.xirOverlayPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionOverlayXIR"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.baselinePartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionBaseline"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
            }
        });
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.chromatogramOverlayPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
    }

    private void createScansTask(Composite parent) {
        Image imageActive = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/selectedScansActive.gif", "16x16");
        Image imageDefault = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/selectedScansDefault.gif", "16x16");
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Toggle the scan(s) modus");
        button.setImage(imageDefault);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.targetsPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionTargets"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.scanChartPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionScanChart"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.scanTablePartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionScanTable"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.scanBrowsePartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionScanBrowse"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
            }
        });
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.targetsPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.scanChartPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.scanTablePartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.scanBrowsePartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
    }

    private void createPeaksTask(Composite parent) {
        Image imageActive = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/selectedPeaksActive.gif", "16x16");
        Image imageDefault = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/selectedPeaksDefault.gif", "16x16");
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Toggle the peak(s) modus");
        button.setImage(imageDefault);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.peakChartPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionPeakChart"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.peakDetailsPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionPeakDetails"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.peakDetectorPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionPeakDetector"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.peakTracesPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionPeakTraces"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
            }
        });
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.peakChartPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.peakDetailsPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.peakDetectorPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.peakTracesPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
    }

    private void createListTask(Composite parent) {
        Image imageActive = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/scanPeakListActive.gif", "16x16");
        Image imageDefault = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/scanPeakListDefault.gif", "16x16");
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Toggle the scan/peak list modus");
        button.setImage(imageDefault);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.peakScanListPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionPeakScanList"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
            }
        });
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.peakScanListPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
    }

    private void createQuantitationTask(Composite parent) {
        Image imageActive = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/quantitationActive.gif", "16x16");
        Image imageDefault = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/quantitationDefault.gif", "16x16");
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Toggle the quantitation modus");
        button.setImage(imageDefault);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.partdescriptor.peakQuantitationListPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionPeakQuantitationList"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.quantitationPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionQuantitation"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.integrationAreaPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionIntegrationArea"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
            }
        });
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.partdescriptor.peakQuantitationListPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.quantitationPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.integrationAreaPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
    }

    private void createInternalStandardsTask(Composite parent) {
        Image imageActive = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/internalStandardsActive.gif", "16x16");
        Image imageDefault = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/internalStandardsDefault.gif", "16x16");
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Toggle the internal standards modus");
        button.setImage(imageDefault);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.internalStandardsPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionInternalStandards"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.partdescriptor.peakQuantitationReferencesPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionPeakQuantitationReferences"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
            }
        });
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.internalStandardsPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.partdescriptor.peakQuantitationReferencesPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
    }

    private void createExternalStandardsTask(Composite parent) {
        Image imageActive = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/externalStandardsActive.gif", "16x16");
        Image imageDefault = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/externalStandardsDefault.gif", "16x16");
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Toggle the external standards modus");
        button.setImage(imageDefault);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.quantPeaksListPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionQuantPeaksList"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.quantPeaksChartPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionQuantPeaksChart"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.quantSignalsListPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionQuantSignalsList"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.quantResponseListPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionQuantResponseList"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.quantResponseChartPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionQuantResponseChart"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
            }
        });
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.quantPeaksListPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.quantPeaksChartPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.quantSignalsListPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.quantResponseListPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.quantResponseChartPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
    }

    private void createSubtractScanTask(Composite parent) {
        Image imageActive = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/subtractScanActive.gif", "16x16");
        Image imageDefault = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/subtractScanDefault.gif", "16x16");
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Toggle the subtract scan modus");
        button.setImage(imageDefault);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.subtractScanPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionSubtractScanPart"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
            }
        });
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.subtractScanPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
    }

    private void createCombinedScanTask(Composite parent) {
        Image imageActive = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/combinedScanActive.gif", "16x16");
        Image imageDefault = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/combinedScanDefault.gif", "16x16");
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Toggle the combined scan modus");
        button.setImage(imageDefault);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.combinedScanPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionCombinedScanPart"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
            }
        });
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.combinedScanPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
    }

    private void createComparisonScanTask(Composite parent) {
        Image imageActive = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/comparisonScanActive.gif", "16x16");
        Image imageDefault = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/comparisonScanDefault.gif", "16x16");
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Toggle the comparison scan modus");
        button.setImage(imageDefault);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.comparisonScanPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionComparisonScanChart"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
            }
        });
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.part.comparisonScanPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
    }

    private void createMeasurementResultTask(Composite parent) {
        Image imageActive = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/measurementResultsActive.gif", "16x16");
        Image imageDefault = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/measurementResultsDefault.gif", "16x16");
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Toggle the measurement result modus");
        button.setImage(imageDefault);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.partdescriptor.measurementResultsPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionMeasurementResults"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
            }
        });
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.partdescriptor.measurementResultsPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
    }

    private void createHeatmapTask(Composite parent) {
        Image imageActive = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/heatmapActive.gif", "16x16");
        Image imageDefault = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/heatmapDefault.gif", "16x16");
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Toggle the heatmap modus");
        button.setImage(imageDefault);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.partdescriptor.chromatogramHeatmapPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionChromatogramHeatmap"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
            }
        });
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.partdescriptor.chromatogramHeatmapPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
    }

    private void createPcrTask(Composite parent) {
        Image imageActive = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/pcrActive.gif", "16x16");
        Image imageDefault = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/pcrDefault.gif", "16x16");
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Toggle the PCR modus");
        button.setImage(imageDefault);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.partdescriptor.plateChartsPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionPlateCharts"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.partdescriptor.wellDataPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionWellData"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.partdescriptor.wellChartPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionWellChart"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.partdescriptor.wellChannelsPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionWellChannels"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
                PartSupport.togglePartVisibility((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.partdescriptor.plateDataPartDescriptor", (String)TaskQuickAccessPart.this.preferenceStore.getString("stackPositionPlateData"), (EPartService)TaskQuickAccessPart.this.partService, (EModelService)TaskQuickAccessPart.this.modelService, (MApplication)TaskQuickAccessPart.this.application, (IEventBroker)TaskQuickAccessPart.this.eventBroker);
            }
        });
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.partdescriptor.plateChartsPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.partdescriptor.wellDataPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.partdescriptor.wellChartPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.partdescriptor.wellChannelsPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
        PartSupport.addPartImageMappings((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.partdescriptor.plateDataPartDescriptor", (Button)button, (Image)imageActive, (Image)imageDefault);
    }

    private void createSettingsTask(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<FieldEditorPreferencePage> preferencePages = new ArrayList<FieldEditorPreferencePage>();
                preferencePages.add(new PreferencePageTasks());
                preferencePages.add(new PreferencePageTaskOverview());
                preferencePages.add(new PreferencePageTaskOverlay());
                preferencePages.add(new PreferencePageTaskScans());
                preferencePages.add(new PreferencePageTaskPeaks());
                preferencePages.add(new PreferencePageTaskLists());
                preferencePages.add(new PreferencePageTaskQuantitation());
                preferencePages.add(new PreferencePageTaskISTD());
                preferencePages.add(new PreferencePageTaskESTD());
                preferencePages.add(new PreferencePageTaskSubtract());
                preferencePages.add(new PreferencePageTaskCombined());
                preferencePages.add(new PreferencePageTaskComparison());
                preferencePages.add(new PreferencePageTaskResults());
                preferencePages.add(new PreferencePageTaskHeatmaps());
                preferencePages.add(new PreferencePageTaskPCR());
                int i = 1;
                PreferenceManager preferenceManager = new PreferenceManager();
                for (IPreferencePage iPreferencePage : preferencePages) {
                    preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode(Integer.toString(i++), iPreferencePage));
                }
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                preferenceDialog.open();
            }
        });
    }
}

