/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.ranges;

import org.eclipse.chemclipse.model.ranges.TimeRange;
import org.eclipse.chemclipse.model.ranges.TimeRanges;
import org.eclipse.chemclipse.model.updates.IUpdateListener;
import org.eclipse.chemclipse.ux.extension.xxd.ui.custom.ChromatogramPeakChart;
import org.eclipse.chemclipse.ux.extension.xxd.ui.ranges.TimeRangeMarker;
import org.eclipse.chemclipse.ux.extension.xxd.ui.ranges.TimeRangeSelector;
import org.eclipse.chemclipse.ux.extension.xxd.ui.ranges.TimeRangesUI;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swtchart.ICustomPaintListener;
import org.eclipse.swtchart.IPlotArea;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ICustomSelectionHandler;
import org.eclipse.swtchart.extensions.core.ScrollableChart;

public class TimeRangesChromatogramUI
extends Composite {
    private TimeRangesUI timeRangesUI;
    private ChromatogramPeakChart chromatogramChart;
    private TimeRangeMarker timeRangeMarker;
    private TimeRanges timeRanges = null;
    private TimeRangeSelector timeRangeSelector = new TimeRangeSelector();

    public TimeRangesChromatogramUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void setTimeRanges(TimeRanges timeRanges) {
        this.timeRanges = timeRanges;
        this.timeRangesUI.setInput(timeRanges);
        this.updateTimeRangeMarker();
    }

    public ChromatogramPeakChart getChromatogramChart() {
        return this.chromatogramChart;
    }

    private void createControl() {
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        this.setLayout((Layout)gridLayout);
        this.timeRangesUI = this.createTimeRangesUI(this);
        this.chromatogramChart = this.createChromatogram(this);
    }

    private TimeRangesUI createTimeRangesUI(Composite parent) {
        TimeRangesUI timeRangesUI = new TimeRangesUI(parent, 0);
        timeRangesUI.setLayoutData(new GridData(768));
        timeRangesUI.setUpdateListener(new IUpdateListener(){

            public void update() {
                if (TimeRangesChromatogramUI.this.timeRanges != null) {
                    TimeRangesChromatogramUI.this.updateTimeRangeMarker();
                }
            }
        });
        return timeRangesUI;
    }

    private ChromatogramPeakChart createChromatogram(Composite parent) {
        ChromatogramPeakChart chromatogramChart = new ChromatogramPeakChart(parent, 0);
        chromatogramChart.setLayoutData(new GridData(1808));
        this.timeRangeMarker = this.addTimeRangeMarker((ScrollableChart)chromatogramChart);
        this.enableTimeRangeAdjustments((ScrollableChart)chromatogramChart);
        return chromatogramChart;
    }

    private TimeRangeMarker addTimeRangeMarker(ScrollableChart scrollableChart) {
        BaseChart baseChart = scrollableChart.getBaseChart();
        IPlotArea plotArea = baseChart.getPlotArea();
        TimeRangeMarker timeRangeMarker = new TimeRangeMarker(baseChart);
        plotArea.addCustomPaintListener((ICustomPaintListener)timeRangeMarker);
        return timeRangeMarker;
    }

    private void enableTimeRangeAdjustments(final ScrollableChart scrollableChart) {
        final BaseChart baseChart = scrollableChart.getBaseChart();
        baseChart.addCustomPointSelectionHandler(new ICustomSelectionHandler(){

            public void handleUserSelection(Event event) {
                if (TimeRangesChromatogramUI.this.timeRanges != null) {
                    TimeRange timeRange = TimeRangesChromatogramUI.this.timeRangeSelector.adjustRange(baseChart, event, TimeRangesChromatogramUI.this.timeRanges);
                    if (timeRange != null && TimeRangesChromatogramUI.this.timeRanges != null) {
                        String[] items = TimeRangesChromatogramUI.this.timeRangesUI.getItems();
                        int i = 0;
                        while (i < items.length) {
                            if (items[i].equals(timeRange.getIdentifier())) {
                                TimeRangesChromatogramUI.this.timeRangesUI.select(i);
                                break;
                            }
                            ++i;
                        }
                    }
                    scrollableChart.redraw();
                }
            }
        });
    }

    private void updateTimeRangeMarker() {
        this.timeRangeMarker.getTimeRanges().clear();
        if (this.timeRanges != null) {
            this.timeRangeMarker.getTimeRanges().addAll(this.timeRanges.values());
        }
        this.chromatogramChart.getBaseChart().redraw();
    }
}

