/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.segments;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.eclipse.chemclipse.model.support.AnalysisSegment;
import org.eclipse.chemclipse.model.support.IAnalysisSegment;
import org.eclipse.chemclipse.model.support.IScanRange;
import org.eclipse.chemclipse.support.ui.swt.columns.ColumnDefinition;
import org.eclipse.chemclipse.support.ui.swt.columns.ColumnDefinitionProvider;
import org.eclipse.chemclipse.support.ui.swt.columns.SimpleColumnDefinition;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.IntegerColumnEditingSupport;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TreeNode;

public class AnalysisSegmentColumnDefinition
implements ColumnDefinitionProvider {
    private final Runnable updateListener;

    public AnalysisSegmentColumnDefinition(Runnable updateListener) {
        this.updateListener = updateListener;
    }

    public List<ColumnDefinition<?, ?>> getColumnDefinitions() {
        ArrayList list = new ArrayList();
        list.add((ColumnDefinition<?, ?>)new SimpleColumnDefinition("Start Scan", 100, new AnalysisSegmentColumnLabelProvider<IAnalysisSegment>(IAnalysisSegment.class, IScanRange::getStartScan)).withEditingSupport(viewer -> new IntegerColumnEditingSupport<IAnalysisSegment>((ColumnViewer)viewer, this.getProperty(IScanRange::getStartScan), new BiConsumer<IAnalysisSegment, Integer>(){

            @Override
            public void accept(IAnalysisSegment segment, Integer value) {
                if (segment instanceof AnalysisSegment) {
                    ((AnalysisSegment)segment).setStartScan(value.intValue());
                    AnalysisSegmentColumnDefinition.this.updateListener.run();
                }
            }
        })));
        list.add((ColumnDefinition<?, ?>)new SimpleColumnDefinition("Stop Scan", 100, new AnalysisSegmentColumnLabelProvider<IAnalysisSegment>(IAnalysisSegment.class, IScanRange::getStopScan)).withEditingSupport(viewer -> new IntegerColumnEditingSupport<IAnalysisSegment>((ColumnViewer)viewer, this.getProperty(IScanRange::getStopScan), new BiConsumer<IAnalysisSegment, Integer>(){

            @Override
            public void accept(IAnalysisSegment segment, Integer value) {
                if (segment instanceof AnalysisSegment) {
                    ((AnalysisSegment)segment).setStopScan(value.intValue());
                    AnalysisSegmentColumnDefinition.this.updateListener.run();
                }
            }
        })));
        list.add((ColumnDefinition<?, ?>)new SimpleColumnDefinition("Width", 100, new AnalysisSegmentColumnLabelProvider<IAnalysisSegment>(IAnalysisSegment.class, IScanRange::getWidth)));
        return list;
    }

    private Function<IAnalysisSegment, Integer> getProperty(Function<IAnalysisSegment, Integer> propertyFunction) {
        return propertyFunction.compose(new Function<IAnalysisSegment, IAnalysisSegment>(){

            @Override
            public IAnalysisSegment apply(IAnalysisSegment segment) {
                if (segment instanceof AnalysisSegment) {
                    return segment;
                }
                return null;
            }
        });
    }

    protected static final class AnalysisSegmentColumnLabelProvider<X extends IAnalysisSegment>
    extends ColumnLabelProvider {
        private final Function<X, Object> converter;
        private final Class<X> type;

        public AnalysisSegmentColumnLabelProvider(Class<X> type, Function<X, Object> converter) {
            this.type = type;
            this.converter = converter;
        }

        public String getText(Object element) {
            if (element instanceof TreeNode) {
                element = ((TreeNode)element).getValue();
            }
            if (this.type.isInstance(element)) {
                return String.valueOf(this.converter.apply((IAnalysisSegment)this.type.cast(element)));
            }
            return "-";
        }
    }
}

