/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.support;

import java.util.function.Function;
import org.eclipse.chemclipse.model.comparator.TargetExtendedComparator;
import org.eclipse.chemclipse.model.core.Classifiable;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.support.comparator.SortOrder;

public interface TargetDisplaySettings {
    public static final TargetExtendedComparator COMPARATOR = new TargetExtendedComparator(SortOrder.DESC);

    public boolean isShowPeakLabels();

    public boolean isShowScanLables();

    public void setShowPeakLabels(boolean var1);

    public void setShowScanLables(boolean var1);

    public int getRotation();

    public int getCollisionDetectionDepth();

    public void setCollisionDetectionDepth(int var1);

    public void setRotation(int var1);

    public LibraryField getField();

    public void setField(LibraryField var1);

    public static enum LibraryField {
        NAME("Name", LibraryField.libraryExtractor(ILibraryInformation::getName)),
        CAS("CAS", LibraryField.libraryExtractor(ILibraryInformation::getCasNumber)),
        CLASSIFICATION("Classifications", LibraryField.libraryExtractor(Classifiable::getClassifier).andThen(elements -> elements != null ? String.join((CharSequence)"; ", elements) : null)),
        FORMULA("Formula", LibraryField.libraryExtractor(ILibraryInformation::getFormula)),
        SYNONYMS("Synonyms", LibraryField.libraryExtractor(ILibraryInformation::getSynonyms).andThen(elements -> elements != null ? String.join((CharSequence)"; ", elements) : null));

        private final Function<IIdentificationTarget, String> transformer;
        private final String label;

        private LibraryField(String label, Function<IIdentificationTarget, String> transformer) {
            this.label = label;
            this.transformer = transformer;
        }

        public Function<IIdentificationTarget, String> stringTransformer() {
            return this.transformer;
        }

        public String toString() {
            return this.label;
        }

        private static <T> Function<IIdentificationTarget, T> libraryExtractor(Function<ILibraryInformation, T> extractor) {
            return target -> {
                if (target == null) {
                    return null;
                }
                ILibraryInformation information = target.getLibraryInformation();
                if (information == null) {
                    return null;
                }
                return extractor.apply(information);
            };
        }
    }
}

