/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.quantitation.CalibrationMethod;
import org.eclipse.chemclipse.model.quantitation.IResponseSignal;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.core.Point;
import org.eclipse.chemclipse.numeric.equations.IEquation;
import org.eclipse.chemclipse.numeric.equations.LinearEquation;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.core.SeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;
import org.eclipse.swtchart.extensions.linecharts.LineSeriesData;

public class CalibrationChartSupport {
    private static final Logger logger = Logger.getLogger(CalibrationChartSupport.class);

    public ILineSeriesData getLineSeriesData(List<IResponseSignal> signalEntries, String label, Color color) {
        int size = signalEntries.size();
        double[] xSeries = new double[size];
        double[] ySeries = new double[size];
        int i = 0;
        while (i < size) {
            IResponseSignal concentrationResponseEntry = signalEntries.get(i);
            xSeries[i] = concentrationResponseEntry.getConcentration();
            ySeries[i] = concentrationResponseEntry.getResponse();
            ++i;
        }
        ILineSeriesData lineSeriesData = this.getLineSeriesData(xSeries, ySeries, label, color);
        ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
        lineSeriesSettings.setSymbolType(ILineSeries.PlotSymbolType.CIRCLE);
        lineSeriesSettings.setSymbolSize(5);
        return lineSeriesData;
    }

    public ILineSeriesData getLineSeriesData(List<IResponseSignal> signalEntries, IEquation equation, CalibrationMethod calibrationMethod, boolean useCrossZero, Point pointMin, Point pointMax, String label, Color color) {
        ILineSeriesData lineSeriesData = null;
        switch (calibrationMethod) {
            case LINEAR: {
                label = String.valueOf(label) + " eq";
                if (((LinearEquation)equation).getA() < 0.0) {
                    lineSeriesData = this.getErrorEquationSeries(label, color);
                    break;
                }
                lineSeriesData = this.calculateLinearEquationSeries(equation, useCrossZero, pointMin, pointMax, label, color);
                break;
            }
            case QUADRATIC: {
                label = String.valueOf(label) + " eq^2";
                try {
                    lineSeriesData = this.calculateQuadraticEquationSeries(equation, useCrossZero, pointMin, pointMax, label, color);
                }
                catch (Exception e) {
                    lineSeriesData = this.getErrorEquationSeries(label, color);
                }
                break;
            }
            case AVERAGE: {
                label = String.valueOf(label) + " avg";
                try {
                    lineSeriesData = this.calculateAverageSeries(signalEntries, label, color);
                }
                catch (Exception e) {
                    lineSeriesData = this.getErrorEquationSeries(label, color);
                }
                break;
            }
            case ISTD: {
                logger.warn((Object)"ISTD shouldn't be used here.");
            }
        }
        return lineSeriesData;
    }

    private ILineSeriesData calculateLinearEquationSeries(IEquation equation, boolean useCrossZero, Point pointMin, Point pointMax, String label, Color color) {
        double[] xSeries = new double[2];
        double[] ySeries = new double[2];
        if (useCrossZero) {
            xSeries[0] = 0.0;
            ySeries[0] = 0.0;
        } else {
            xSeries[0] = pointMin.getX();
            ySeries[0] = pointMin.getY();
        }
        xSeries[1] = pointMax.getX();
        ySeries[1] = equation.calculateY(pointMax.getX());
        ILineSeriesData lineSeriesData = this.getLineSeriesData(xSeries, ySeries, label, color);
        ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
        lineSeriesSettings.setLineStyle(LineStyle.SOLID);
        return lineSeriesData;
    }

    private ILineSeriesData calculateQuadraticEquationSeries(IEquation equation, boolean useCrossZero, Point pointMin, Point pointMax, String label, Color color) {
        int steps = 50;
        double xStart = useCrossZero ? 0.0 : pointMin.getX();
        double xStep = (pointMax.getX() - xStart) / (double)steps;
        ArrayList<Point> points = new ArrayList<Point>();
        double x = xStart;
        while (x < pointMax.getX()) {
            double y = equation.calculateY(x);
            if (y > 0.0) {
                points.add(new Point(x, y));
            }
            x += xStep;
        }
        double[] xSeries = new double[points.size()];
        double[] ySeries = new double[points.size()];
        int index = 0;
        while (index < points.size()) {
            IPoint point = (IPoint)points.get(index);
            xSeries[index] = point.getX();
            ySeries[index] = point.getY();
            ++index;
        }
        ILineSeriesData lineSeriesData = this.getLineSeriesData(xSeries, ySeries, label, color);
        ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
        lineSeriesSettings.setLineStyle(LineStyle.SOLID);
        return lineSeriesData;
    }

    private ILineSeriesData calculateAverageSeries(List<IResponseSignal> entries, String label, Color color) {
        double x = 0.0;
        double y = 0.0;
        int size = entries.size();
        if (size == 0) {
            return null;
        }
        for (IResponseSignal entry : entries) {
            x += entry.getConcentration();
            y += entry.getResponse();
        }
        double[] xSeries = new double[]{x /= (double)size};
        double[] ySeries = new double[]{y /= (double)size};
        ILineSeriesData lineSeriesData = this.getLineSeriesData(xSeries, ySeries, label, color);
        ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
        lineSeriesSettings.setSymbolSize(6);
        lineSeriesSettings.setSymbolType(ILineSeries.PlotSymbolType.CROSS);
        return lineSeriesData;
    }

    private ILineSeriesData getErrorEquationSeries(String label, Color color) {
        double[] xSeries = new double[]{0.0};
        double[] ySeries = new double[]{0.0};
        return this.getLineSeriesData(xSeries, ySeries, label, color);
    }

    private ILineSeriesData getLineSeriesData(double[] xSeries, double[] ySeries, String label, Color color) {
        SeriesData seriesData = new SeriesData(xSeries, ySeries, label);
        LineSeriesData lineSeriesData = new LineSeriesData((ISeriesData)seriesData);
        ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
        lineSeriesSettings.setLineStyle(LineStyle.NONE);
        lineSeriesSettings.setLineWidth(1);
        lineSeriesSettings.setLineColor(color);
        lineSeriesSettings.setEnableArea(false);
        lineSeriesSettings.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeriesSettings.setSymbolColor(color);
        lineSeriesSettings.setSymbolSize(1);
        return lineSeriesData;
    }
}

