/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractLabelProvider;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.support.OverlayChartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.validation.ShiftValidator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.DisplayModus;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ISeriesSet;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IAxisSettings;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.ISeriesStatusListener;
import org.eclipse.swtchart.extensions.core.MappedSeriesSettings;
import org.eclipse.swtchart.extensions.core.RangeRestriction;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.core.SeriesStatusAdapter;

public class DataShiftControllerUI
extends Composite {
    private static final String SERIES_REDRAW = "";
    private static final String SERIES_ALL = "";
    private static final String BUTTON_MIRROR_KEY = "DisplayModus";
    private static final String normalTooltip = "Set the selected series to normal modus.";
    private static final String mirrorTooltip = "Set the selected series to mirrored modus.";
    private Text textX;
    private ComboViewer comboViewerX;
    private Text textY;
    private ComboViewer comboViewerY;
    private ComboViewer comboViewerSelect;
    private Button buttonMirrorSeries;
    private Button buttonShiftLeft;
    private Button buttonShiftRight;
    private Button buttonShiftUp;
    private Button buttonShiftDown;
    private ScrollableChart scrollableChart = null;
    private BaseChart baseChart = null;
    private final OverlayChartSupport overlayChartSupport = new OverlayChartSupport();
    private final Set<String> mirroredSeries = new HashSet<String>();

    public DataShiftControllerUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void setScrollableChart(ScrollableChart scrollableChart) {
        this.scrollableChart = scrollableChart;
        if (scrollableChart != null) {
            this.baseChart = scrollableChart.getBaseChart();
            this.baseChart.addSeriesStatusListener((ISeriesStatusListener)new SeriesStatusAdapter(){

                public void handleSeriesSelectionEvent(String seriesId) {
                    DataShiftControllerUI.this.updateComboViewerSelect(seriesId);
                }

                public void handleRedrawEvent() {
                    DataShiftControllerUI.this.updateComboViewerSelect("");
                }
            });
        }
    }

    public void update() {
        super.update();
        this.setAxisValues();
        this.updateComboViewerSelect(BaseChart.SELECTED_SERIES_NONE);
    }

    public void reset() {
        if (this.baseChart != null) {
            this.baseChart.resetSeriesSettings();
            this.mirroredSeries.clear();
        }
        this.updateComboViewerSelect(BaseChart.SELECTED_SERIES_NONE);
    }

    protected void setDisplayModus(DisplayModus displayModus, String seriesId) {
        if (this.scrollableChart != null) {
            BaseChart baseChart = this.scrollableChart.getBaseChart();
            IChartSettings chartSettings = this.scrollableChart.getChartSettings();
            if (DisplayModus.MIRRORED.equals((Object)displayModus)) {
                if (!this.mirroredSeries.contains(seriesId)) {
                    baseChart.multiplySeries(seriesId, "Y_AXIS", -1.0);
                    this.mirroredSeries.add(seriesId);
                }
            } else if (this.mirroredSeries.contains(seriesId)) {
                baseChart.multiplySeries(seriesId, "Y_AXIS", -1.0);
                this.mirroredSeries.remove(seriesId);
            }
            this.modifyWidgetStatus();
            this.scrollableChart.applySettings(chartSettings);
            this.scrollableChart.adjustRange(true);
            this.scrollableChart.redraw();
        }
    }

    private void createControl() {
        GridLayout gridLayout = new GridLayout(14, false);
        this.setLayout((Layout)gridLayout);
        this.createButtonAutoMirror(this);
        this.createVerticalSeparator(this);
        this.textX = this.createTextX(this);
        this.comboViewerX = this.createComboViewerX(this);
        this.textY = this.createTextY(this);
        this.comboViewerY = this.createComboViewerY(this);
        this.createButtonShift(this);
        this.createVerticalSeparator(this);
        this.comboViewerSelect = this.createComboViewerSelect(this);
        this.buttonMirrorSeries = this.createButtonMirror(this);
        this.buttonShiftLeft = this.createButtonLeft(this);
        this.buttonShiftRight = this.createButtonRight(this);
        this.buttonShiftUp = this.createButtonUp(this);
        this.buttonShiftDown = this.createButtonDown(this);
    }

    private Text createTextX(Composite parent) {
        final String tooltip = "Shift data in x direction.";
        final Text text = new Text(parent, 2048);
        text.setText("");
        text.setToolTipText(tooltip);
        GridData gridData = new GridData(768);
        gridData.widthHint = 150;
        text.setLayoutData((Object)gridData);
        final ShiftValidator shiftValidator = new ShiftValidator();
        final ControlDecoration controlDecoration = new ControlDecoration((Control)text, 16512);
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                if (DataShiftControllerUI.this.validate(shiftValidator, controlDecoration, tooltip, text) && (e.keyCode == 10 || e.keyCode == 13 || e.keyCode == 0x1000050) && DataShiftControllerUI.this.baseChart != null) {
                    double deltaX = DataShiftControllerUI.this.getShiftValuePrimary("X_AXIS");
                    double deltaY = 0.0;
                    DataShiftControllerUI.this.shiftSeries("", deltaX, deltaY);
                }
            }
        });
        return text;
    }

    private ComboViewer createComboViewerX(Composite parent) {
        final ComboViewer comboViewer = new ComboViewer(parent, 8);
        Combo combo = comboViewer.getCombo();
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IAxisSettings) {
                    IAxisSettings axisSettings = (IAxisSettings)element;
                    return axisSettings.getLabel();
                }
                return null;
            }
        });
        combo.setToolTipText("Select the x axis.");
        GridData gridData = new GridData(768);
        gridData.widthHint = 150;
        combo.setLayoutData((Object)gridData);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = comboViewer.getStructuredSelection().getFirstElement();
                if (object instanceof IAxisSettings) {
                    DataShiftControllerUI.this.persistOverlayShiftX();
                }
            }
        });
        return comboViewer;
    }

    private Text createTextY(Composite parent) {
        final String tooltip = "Shift data in y direction.";
        final Text text = new Text(parent, 2048);
        text.setText("");
        text.setToolTipText(tooltip);
        GridData gridData = new GridData(768);
        gridData.widthHint = 150;
        text.setLayoutData((Object)gridData);
        final ShiftValidator shiftValidator = new ShiftValidator();
        final ControlDecoration controlDecoration = new ControlDecoration((Control)text, 16512);
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                if (DataShiftControllerUI.this.validate(shiftValidator, controlDecoration, tooltip, text) && (e.keyCode == 10 || e.keyCode == 13 || e.keyCode == 0x1000050) && DataShiftControllerUI.this.baseChart != null) {
                    double deltaX = 0.0;
                    double deltaY = DataShiftControllerUI.this.getShiftValuePrimary("Y_AXIS");
                    DataShiftControllerUI.this.shiftSeries("", deltaX, deltaY);
                }
            }
        });
        return text;
    }

    private ComboViewer createComboViewerY(Composite parent) {
        final ComboViewer comboViewer = new ComboViewer(parent, 8);
        Combo combo = comboViewer.getCombo();
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IAxisSettings) {
                    IAxisSettings axisSettings = (IAxisSettings)element;
                    return axisSettings.getLabel();
                }
                return null;
            }
        });
        combo.setToolTipText("Select the y axis.");
        GridData gridData = new GridData(768);
        gridData.widthHint = 150;
        combo.setLayoutData((Object)gridData);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = comboViewer.getStructuredSelection().getFirstElement();
                if (object instanceof IAxisSettings) {
                    DataShiftControllerUI.this.persistOverlayShiftY();
                }
            }
        });
        return comboViewer;
    }

    private void createVerticalSeparator(Composite parent) {
        Label label = new Label(parent, 514);
        GridData gridData = new GridData();
        gridData.heightHint = 35;
        label.setLayoutData((Object)gridData);
    }

    private Button createButtonShift(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Shift the data in XY direction.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/execute.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DataShiftControllerUI.this.baseChart != null) {
                    double deltaX = DataShiftControllerUI.this.getShiftValuePrimary("X_AXIS");
                    double deltaY = DataShiftControllerUI.this.getShiftValuePrimary("Y_AXIS");
                    DataShiftControllerUI.this.shiftSeries("", deltaX, deltaY);
                }
            }
        });
        return button;
    }

    private void createButtonAutoMirror(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Auto Mirror Chromatograms");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/shiftAutoMirror.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DataShiftControllerUI.this.scrollableChart != null) {
                    IChartSettings chartSettings = DataShiftControllerUI.this.scrollableChart.getChartSettings();
                    int i = 0;
                    ISeries[] iSeriesArray = DataShiftControllerUI.this.baseChart.getSeriesSet().getSeries();
                    int n = iSeriesArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ISeries series = iSeriesArray[n2];
                        if (i % 2 == 1) {
                            String seriesId = series.getId();
                            if (!DataShiftControllerUI.this.mirroredSeries.contains(seriesId)) {
                                DataShiftControllerUI.this.baseChart.multiplySeries(seriesId, "Y_AXIS", -1.0);
                                DataShiftControllerUI.this.mirroredSeries.add(seriesId);
                            }
                        }
                        ++i;
                        ++n2;
                    }
                    DataShiftControllerUI.this.scrollableChart.applySettings(chartSettings);
                    DataShiftControllerUI.this.scrollableChart.adjustRange(true);
                    DataShiftControllerUI.this.scrollableChart.redraw();
                }
            }
        });
    }

    private ComboViewer createComboViewerSelect(Composite parent) {
        final ComboViewer comboViewer = new ComboViewer(parent, 8);
        Combo combo = comboViewer.getCombo();
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MappedSeriesSettings) {
                    MappedSeriesSettings mappedSeriesSettings = (MappedSeriesSettings)element;
                    ISeriesSettings seriesSettings = mappedSeriesSettings.getSeriesSettings();
                    if (seriesSettings != null) {
                        return seriesSettings.getDescription();
                    }
                    return mappedSeriesSettings.getIdentifier();
                }
                return null;
            }
        });
        combo.setToolTipText("Highlight the selected series.");
        GridData gridData = new GridData(768);
        gridData.widthHint = 150;
        combo.setLayoutData((Object)gridData);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = comboViewer.getStructuredSelection().getFirstElement();
                if (object instanceof MappedSeriesSettings) {
                    MappedSeriesSettings mappedSeriesSettings = (MappedSeriesSettings)object;
                    if (DataShiftControllerUI.this.baseChart != null) {
                        String identifier = mappedSeriesSettings.getIdentifier();
                        DataShiftControllerUI.this.baseChart.resetSeriesSettings();
                        DataShiftControllerUI.this.baseChart.selectSeries(identifier);
                        DataShiftControllerUI.this.baseChart.redraw();
                        DataShiftControllerUI.this.modifyWidgetStatus();
                    }
                }
            }
        });
        return comboViewer;
    }

    private Button createButtonMirror(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/shiftMirror.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = button.getData(DataShiftControllerUI.BUTTON_MIRROR_KEY);
                DisplayModus displayModus = object instanceof DisplayModus ? (DisplayModus)((Object)object) : DisplayModus.NORMAL;
                DataShiftControllerUI.this.setDisplayModus(displayModus, DataShiftControllerUI.this.getSelectedSeriesId());
                DataShiftControllerUI.this.updateComboViewerSelect(BaseChart.SELECTED_SERIES_NONE);
            }
        });
        return button;
    }

    private Button createButtonLeft(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Move Left");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/arrowBackward.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DataShiftControllerUI.this.baseChart != null) {
                    String seriesId = DataShiftControllerUI.this.getSelectedSeriesId();
                    double deltaX = DataShiftControllerUI.this.getShiftValuePrimary("X_AXIS") * -1.0;
                    double deltaY = 0.0;
                    DataShiftControllerUI.this.shiftSeries(seriesId, deltaX, deltaY);
                }
            }
        });
        return button;
    }

    private Button createButtonRight(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Move Right");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/arrowForward.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DataShiftControllerUI.this.baseChart != null) {
                    String seriesId = DataShiftControllerUI.this.getSelectedSeriesId();
                    double deltaX = DataShiftControllerUI.this.getShiftValuePrimary("X_AXIS");
                    double deltaY = 0.0;
                    DataShiftControllerUI.this.shiftSeries(seriesId, deltaX, deltaY);
                }
            }
        });
        return button;
    }

    private Button createButtonUp(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Move Up");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/arrow_up_2.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DataShiftControllerUI.this.baseChart != null) {
                    String seriesId = DataShiftControllerUI.this.getSelectedSeriesId();
                    double deltaX = 0.0;
                    double deltaY = DataShiftControllerUI.this.getShiftValuePrimary("Y_AXIS");
                    DataShiftControllerUI.this.shiftSeries(seriesId, deltaX, deltaY);
                }
            }
        });
        return button;
    }

    private Button createButtonDown(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Move Down");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/arrow_down_2.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DataShiftControllerUI.this.baseChart != null) {
                    String seriesId = DataShiftControllerUI.this.getSelectedSeriesId();
                    double deltaX = 0.0;
                    double deltaY = DataShiftControllerUI.this.getShiftValuePrimary("Y_AXIS") * -1.0;
                    DataShiftControllerUI.this.shiftSeries(seriesId, deltaX, deltaY);
                }
            }
        });
        return button;
    }

    public void setAxisValues() {
        this.setAxisValuesX();
        this.setAxisValuesY();
    }

    private void setAxisValuesX() {
        if (this.baseChart != null) {
            List axisSettings = this.baseChart.getAxisSettings("X_AXIS");
            this.comboViewerX.setInput((Object)axisSettings);
            int size = axisSettings.size();
            if (size > 0) {
                double overlayShiftX = this.overlayChartSupport.getOverlayShiftX();
                int indexShiftX = this.overlayChartSupport.getIndexShiftX();
                Combo combo = this.comboViewerX.getCombo();
                if (indexShiftX >= 0 && indexShiftX < size) {
                    DecimalFormat decimalFormat = this.baseChart.getDecimalFormat("X_AXIS", indexShiftX);
                    combo.select(indexShiftX);
                    this.textX.setText(decimalFormat.format(overlayShiftX));
                } else {
                    combo.select(0);
                    this.textX.setText(Integer.toString(0));
                }
            }
        }
    }

    private void setAxisValuesY() {
        if (this.baseChart != null) {
            List axisSettings = this.baseChart.getAxisSettings("Y_AXIS");
            this.comboViewerY.setInput((Object)axisSettings);
            int size = axisSettings.size();
            if (size > 0) {
                double absoluteShiftY = this.overlayChartSupport.getOverlayShiftY();
                int indexShiftY = this.overlayChartSupport.getIndexShiftY();
                Combo combo = this.comboViewerY.getCombo();
                if (indexShiftY >= 0 && indexShiftY < size) {
                    DecimalFormat decimalFormat = this.baseChart.getDecimalFormat("Y_AXIS", indexShiftY);
                    combo.select(indexShiftY);
                    this.textY.setText(decimalFormat.format(absoluteShiftY));
                } else {
                    combo.select(0);
                    this.textY.setText(Double.toString(0.0));
                }
            }
        }
    }

    private void modifyWidgetStatus() {
        String selectedSeries = this.getSelectedSeriesId();
        boolean isSeriesSelected = !selectedSeries.equals(BaseChart.SELECTED_SERIES_NONE);
        this.buttonShiftLeft.setEnabled(isSeriesSelected);
        this.buttonShiftRight.setEnabled(isSeriesSelected);
        this.buttonShiftUp.setEnabled(isSeriesSelected);
        this.buttonShiftDown.setEnabled(isSeriesSelected);
        this.buttonMirrorSeries.setEnabled(isSeriesSelected);
        if (this.mirroredSeries.contains(selectedSeries)) {
            this.buttonMirrorSeries.setData(BUTTON_MIRROR_KEY, (Object)DisplayModus.NORMAL);
            this.buttonMirrorSeries.setToolTipText(normalTooltip);
        } else {
            this.buttonMirrorSeries.setData(BUTTON_MIRROR_KEY, (Object)DisplayModus.MIRRORED);
            this.buttonMirrorSeries.setToolTipText(mirrorTooltip);
        }
    }

    private double getShiftValuePrimary(String axis) {
        double shiftValue = 0.0;
        if (this.baseChart != null) {
            int selectedAxis = axis.equals("X_AXIS") ? this.comboViewerX.getCombo().getSelectionIndex() : this.comboViewerY.getCombo().getSelectionIndex();
            double value = axis.equals("X_AXIS") ? this.getShift(this.textX) : this.getShift(this.textY);
            if (selectedAxis == 0) {
                shiftValue = value;
            } else {
                IAxisScaleConverter axisScaleConverter = this.baseChart.getAxisScaleConverter(axis, selectedAxis);
                shiftValue = axisScaleConverter.convertToPrimaryUnit(value);
            }
        }
        return shiftValue;
    }

    private double getShift(Text text) {
        double shift = 0.0;
        ShiftValidator shiftValidator = new ShiftValidator();
        IStatus status = shiftValidator.validate(text.getText().trim());
        if (status.isOK()) {
            shift = shiftValidator.getShift();
        }
        return shift;
    }

    private void persistOverlayShiftX() {
        this.overlayChartSupport.setOverlayShiftX(this.getShift(this.textX));
        this.overlayChartSupport.setIndexShiftX(this.comboViewerX.getCombo().getSelectionIndex());
    }

    private void persistOverlayShiftY() {
        this.overlayChartSupport.setOverlayShiftY(this.getShift(this.textY));
        this.overlayChartSupport.setIndexShiftY(this.comboViewerY.getCombo().getSelectionIndex());
    }

    private void updateComboViewerSelect(String seriesId) {
        ISeriesSet seriesSet;
        if (seriesId.equals("")) {
            seriesId = this.getSelectedSeriesId();
        }
        ArrayList<MappedSeriesSettings> mappedSettings = new ArrayList<MappedSeriesSettings>();
        mappedSettings.add(new MappedSeriesSettings(BaseChart.SELECTED_SERIES_NONE, null));
        String label = BaseChart.SELECTED_SERIES_NONE;
        if (this.baseChart != null && (seriesSet = this.baseChart.getSeriesSet()) != null) {
            ISeries[] iSeriesArray = seriesSet.getSeries();
            int n = iSeriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries series = iSeriesArray[n2];
                String id = series.getId();
                ISeriesSettings seriesSettings = this.baseChart.getSeriesSettings(id);
                if (seriesSettings != null) {
                    mappedSettings.add(new MappedSeriesSettings(id, seriesSettings));
                    if (id.equals(seriesId)) {
                        String description = seriesSettings.getDescription();
                        label = !"".equals(description) ? description : id;
                    }
                }
                ++n2;
            }
        }
        this.comboViewerSelect.setInput(mappedSettings);
        this.comboViewerSelect.getCombo().setText(label);
        this.modifyWidgetStatus();
    }

    private String getSelectedSeriesId() {
        String id = BaseChart.SELECTED_SERIES_NONE;
        Combo combo = this.comboViewerSelect.getCombo();
        int index = combo.getSelectionIndex();
        Object object = this.comboViewerSelect.getElementAt(index);
        if (object instanceof MappedSeriesSettings) {
            MappedSeriesSettings mappedSeriesSettings = (MappedSeriesSettings)object;
            id = mappedSeriesSettings.getIdentifier();
        }
        return id;
    }

    private boolean validate(IValidator validator, ControlDecoration controlDecoration, String tooltip, Text text) {
        IStatus status = validator.validate((Object)text.getText().trim());
        if (status.isOK()) {
            controlDecoration.hide();
            text.setToolTipText(tooltip);
            return true;
        }
        controlDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        controlDecoration.showHoverText(status.getMessage());
        controlDecoration.show();
        text.setToolTipText(status.getMessage());
        return false;
    }

    private void shiftSeries(String seriesId, double deltaX, double deltaY) {
        if (this.scrollableChart != null) {
            this.baseChart.suspendUpdate(true);
            double shiftX = 0.0;
            double shiftY = 0.0;
            ISeries[] iSeriesArray = this.baseChart.getSeriesSet().getSeries();
            int n = iSeriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries series = iSeriesArray[n2];
                boolean shift = false;
                if (seriesId.equals("")) {
                    shift = true;
                } else if (seriesId.equals(series.getId())) {
                    shift = true;
                }
                if (shift) {
                    this.baseChart.shiftSeries(series.getId(), shiftX += deltaX, shiftY += deltaY);
                }
                ++n2;
            }
            IChartSettings chartSettings = this.scrollableChart.getChartSettings();
            RangeRestriction rangeRestriction = chartSettings.getRangeRestriction();
            rangeRestriction.setExtendTypeX(RangeRestriction.ExtendType.ABSOLUTE);
            rangeRestriction.setExtendMaxX(rangeRestriction.getExtendMaxX() + shiftX);
            rangeRestriction.setExtendTypeY(RangeRestriction.ExtendType.ABSOLUTE);
            rangeRestriction.setExtendMaxY(rangeRestriction.getExtendMaxY() + shiftY);
            this.scrollableChart.applySettings(chartSettings);
            this.baseChart.suspendUpdate(false);
            this.scrollableChart.redraw();
            this.persistOverlayShiftX();
            this.persistOverlayShiftY();
        }
    }
}

