/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.chemclipse.pcr.model.comparators.DetectionFormatComparator;
import org.eclipse.chemclipse.pcr.model.core.IChannelSpecification;
import org.eclipse.chemclipse.pcr.model.core.IDetectionFormat;
import org.eclipse.chemclipse.pcr.model.core.IPlate;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractLabelProvider;
import org.eclipse.chemclipse.support.ui.provider.ListContentProvider;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePagePCR;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ChannelSpecificationListUI;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ExtendedPlateDataUI {
    private Label labelInfo;
    private Composite toolbarInfo;
    private ComboViewer comboDetectionFormats;
    private ComboViewer comboChannelSpecifications;
    private ChannelSpecificationListUI channelSpecificationListUI;
    private DetectionFormatComparator detectionFormatComparator = new DetectionFormatComparator();
    private IPlate plate = null;

    @Inject
    public ExtendedPlateDataUI(Composite parent) {
        this.initialize(parent);
    }

    public void update(IPlate plate) {
        this.plate = plate;
        this.updateLabel();
        this.updateDetectionFormats();
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(parent);
        this.toolbarInfo = this.createToolbarInfo(parent);
        this.comboDetectionFormats = this.createComboDetectionFormats(parent);
        this.comboChannelSpecifications = this.createComboChannelSpecifications(parent);
        this.channelSpecificationListUI = this.createChannelSpecificationTable(parent);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfo, (boolean)true);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.createButtonToggleToolbarInfo(composite);
        this.createResetButton(composite);
        this.createSettingsButton(composite);
    }

    private Button createButtonToggleToolbarInfo(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle info toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedPlateDataUI.this.toolbarInfo);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private void createResetButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Reset");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/reset.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExtendedPlateDataUI.this.plate != null) {
                    ExtendedPlateDataUI.this.plate.setDetectionFormat(null);
                    ExtendedPlateDataUI.this.updateDetectionFormats();
                }
            }
        });
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePagePCR preferencePage = new PreferencePagePCR();
                preferencePage.setTitle("PCR");
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)preferencePage));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    // empty if block
                }
            }
        });
    }

    private Composite createToolbarInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelInfo = new Label(composite, 0);
        this.labelInfo.setText("");
        this.labelInfo.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private ComboViewer createComboDetectionFormats(Composite parent) {
        final ComboViewer comboViewer = new ComboViewer(parent, 8);
        Combo combo = comboViewer.getCombo();
        comboViewer.setContentProvider((IContentProvider)new ListContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDetectionFormat) {
                    IDetectionFormat detectionFormat = (IDetectionFormat)element;
                    return detectionFormat.getName();
                }
                return null;
            }
        });
        combo.setToolTipText("Select a detection format and apply it.");
        GridData gridData = new GridData(768);
        gridData.widthHint = 150;
        combo.setLayoutData((Object)gridData);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object;
                if (ExtendedPlateDataUI.this.plate != null && (object = comboViewer.getStructuredSelection().getFirstElement()) instanceof IDetectionFormat) {
                    IDetectionFormat detectionFormat = (IDetectionFormat)object;
                    ExtendedPlateDataUI.this.plate.setDetectionFormat(detectionFormat);
                    ExtendedPlateDataUI.this.updateChannelSpecification(detectionFormat);
                }
            }
        });
        return comboViewer;
    }

    private ComboViewer createComboChannelSpecifications(Composite parent) {
        final ComboViewer comboViewer = new ComboViewer(parent, 8);
        Combo combo = comboViewer.getCombo();
        comboViewer.setContentProvider((IContentProvider)new ListContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IChannelSpecification) {
                    IChannelSpecification channelSpecification = (IChannelSpecification)element;
                    return channelSpecification.getName();
                }
                return null;
            }
        });
        combo.setToolTipText("Select a channel specification.");
        GridData gridData = new GridData(768);
        gridData.widthHint = 150;
        combo.setLayoutData((Object)gridData);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object;
                if (ExtendedPlateDataUI.this.plate != null && (object = comboViewer.getStructuredSelection().getFirstElement()) instanceof IChannelSpecification) {
                    IChannelSpecification channelSpecification = (IChannelSpecification)object;
                    ExtendedPlateDataUI.this.channelSpecificationListUI.setInput(channelSpecification);
                }
            }
        });
        return comboViewer;
    }

    private ChannelSpecificationListUI createChannelSpecificationTable(Composite parent) {
        ChannelSpecificationListUI listUI = new ChannelSpecificationListUI(parent, 68354);
        listUI.getTable().setLayoutData((Object)new GridData(1808));
        return listUI;
    }

    private void updateLabel() {
        if (this.plate != null) {
            this.labelInfo.setText("Plate: " + this.plate.getName());
        } else {
            this.labelInfo.setText("No plate data available.");
        }
    }

    private void updateDetectionFormats() {
        this.comboDetectionFormats.setInput(null);
        this.updateChannelSpecification(null);
        if (this.plate != null) {
            ArrayList detectionFormats = new ArrayList(this.plate.getDetectionFormats());
            Collections.sort(detectionFormats, this.detectionFormatComparator);
            this.comboDetectionFormats.setInput(detectionFormats);
            IDetectionFormat detectionFormat = this.plate.getDetectionFormat();
            if (detectionFormat != null) {
                String[] items = this.comboDetectionFormats.getCombo().getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i].equals(detectionFormat.getName())) {
                        this.comboDetectionFormats.getCombo().select(i);
                        this.updateChannelSpecification(detectionFormat);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private void updateChannelSpecification(IDetectionFormat detectionFormat) {
        IChannelSpecification channelSpecification = null;
        this.comboChannelSpecifications.setInput(null);
        if (detectionFormat != null) {
            List channelSpecifications = detectionFormat.getChannelSpecifications();
            this.comboChannelSpecifications.setInput((Object)channelSpecifications);
            if (channelSpecifications.size() > 0) {
                this.comboChannelSpecifications.getCombo().select(0);
                channelSpecification = (IChannelSpecification)channelSpecifications.get(0);
            }
        }
        this.channelSpecificationListUI.setInput(channelSpecification);
    }
}

