/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.exceptions.InvalidHeaderModificationException;
import org.eclipse.chemclipse.pcr.model.core.IWell;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.menu.ITableMenuEntry;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.support.ui.swt.ITableSettings;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.swt.ui.components.ISearchListener;
import org.eclipse.chemclipse.swt.ui.components.SearchSupportUI;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePagePCR;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.WellDataListUI;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ExtendedWellDataUI {
    private static final String MENU_CATEGORY_HEADER_ENTRIES = "Header Entries";
    private static final String HEADER_ENTRY = "Header Entry";
    private Label labelInfoTop;
    private Composite toolbarInfoTop;
    private Label labelInfoBottom;
    private Composite toolbarInfoBottom;
    private Composite toolbarSearch;
    private Composite toolbarModify;
    private Button buttonToggleEditModus;
    private Text textHeaderKey;
    private Text textHeaderValue;
    private Button buttonAddHeaderEntry;
    private Button buttonDeleteHeaderEntry;
    private WellDataListUI wellDataListUI;
    private IWell well;
    private boolean editable;

    @Inject
    public ExtendedWellDataUI(Composite parent) {
        this.initialize(parent);
    }

    @Focus
    public void setFocus() {
        this.updateHeaderData();
    }

    public void update(IWell well) {
        this.well = well;
        this.editable = well != null;
        this.updateHeaderData();
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(parent);
        this.toolbarInfoTop = this.createToolbarInfoTop(parent);
        this.toolbarSearch = this.createToolbarSearch(parent);
        this.toolbarModify = this.createToolbarModify(parent);
        this.wellDataListUI = this.createWellDataTable(parent);
        this.toolbarInfoBottom = this.createToolbarInfoBottom(parent);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfoTop, (boolean)true);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfoBottom, (boolean)true);
        PartSupport.setCompositeVisibility((Composite)this.toolbarSearch, (boolean)false);
        PartSupport.setCompositeVisibility((Composite)this.toolbarModify, (boolean)false);
        this.wellDataListUI.setEditEnabled(false);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(5, false));
        this.createButtonToggleToolbarInfo(composite);
        this.createButtonToggleToolbarSearch(composite);
        this.createButtonToggleToolbarModify(composite);
        this.buttonToggleEditModus = this.createButtonToggleEditModus(composite);
        this.createSettingsButton(composite);
    }

    private Button createButtonToggleToolbarInfo(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle info toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedWellDataUI.this.toolbarInfoTop);
                PartSupport.toggleCompositeVisibility((Composite)ExtendedWellDataUI.this.toolbarInfoBottom);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarSearch(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle search toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedWellDataUI.this.toolbarSearch);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarModify(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle modify toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedWellDataUI.this.toolbarModify);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editActive.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editDefault.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleEditModus(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Enable/disable to edit the table.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editEntryDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean editEnabled = !ExtendedWellDataUI.this.wellDataListUI.isEditEnabled();
                ExtendedWellDataUI.this.wellDataListUI.setEditEnabled(editEnabled);
                button.setImage(ApplicationImageFactory.getInstance().getImage(editEnabled ? "org.eclipse.chemclipse.rcp.ui.icons/editEntryActive.gif" : "org.eclipse.chemclipse.rcp.ui.icons/editEntryDefault.gif", "16x16"));
                ExtendedWellDataUI.this.updateLabel();
            }
        });
        return button;
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePagePCR preferencePage = new PreferencePagePCR();
                preferencePage.setTitle("PCR");
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)preferencePage));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    // empty if block
                }
            }
        });
    }

    private Composite createToolbarInfoTop(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelInfoTop = new Label(composite, 0);
        this.labelInfoTop.setText("");
        this.labelInfoTop.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private Composite createToolbarInfoBottom(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelInfoBottom = new Label(composite, 0);
        this.labelInfoBottom.setText("");
        this.labelInfoBottom.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private Composite createToolbarSearch(Composite parent) {
        SearchSupportUI searchSupportUI = new SearchSupportUI(parent, 0);
        searchSupportUI.setLayoutData((Object)new GridData(768));
        searchSupportUI.setSearchListener(new ISearchListener(){

            public void performSearch(String searchText, boolean caseSensitive) {
                ExtendedWellDataUI.this.wellDataListUI.setSearchText(searchText, caseSensitive);
            }
        });
        return searchSupportUI;
    }

    private Composite createToolbarModify(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(4, false));
        this.textHeaderKey = this.createTextHeaderKey(composite);
        this.textHeaderValue = this.createTextHeaderValue(composite);
        this.buttonAddHeaderEntry = this.createButtonAdd(composite);
        this.buttonDeleteHeaderEntry = this.createButtonDelete(composite);
        return composite;
    }

    private Text createTextHeaderKey(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setText("");
        text.setToolTipText("Set a new data key.");
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private Text createTextHeaderValue(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setText("");
        text.setToolTipText("Set a new data value.");
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private Button createButtonAdd(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Add the data entry.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/add.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedWellDataUI.this.addHeaderEntry(e.display.getActiveShell());
            }
        });
        return button;
    }

    private Button createButtonDelete(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Delete the selected entrie(s).");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/delete.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedWellDataUI.this.deleteHeaderEntries(e.display.getActiveShell());
            }
        });
        return button;
    }

    private WellDataListUI createWellDataTable(Composite parent) {
        WellDataListUI listUI = new WellDataListUI(parent, 68354);
        listUI.getTable().setLayoutData((Object)new GridData(1808));
        Shell shell = listUI.getTable().getShell();
        ITableSettings tableSettings = listUI.getTableSettings();
        this.addDeleteMenuEntry(shell, tableSettings);
        listUI.applySettings(tableSettings);
        return listUI;
    }

    private void addDeleteMenuEntry(final Shell shell, ITableSettings tableSettings) {
        tableSettings.addMenuEntry(new ITableMenuEntry(){

            public String getName() {
                return "Delete Data Entrie(s)";
            }

            public String getCategory() {
                return ExtendedWellDataUI.MENU_CATEGORY_HEADER_ENTRIES;
            }

            public void execute(ExtendedTableViewer extendedTableViewer) {
                ExtendedWellDataUI.this.deleteHeaderEntries(shell);
            }
        });
    }

    private void addHeaderEntry(Shell shell) {
        if (this.well != null) {
            String key = this.textHeaderKey.getText().trim();
            String value = this.textHeaderValue.getText().trim();
            if ("".equals(key)) {
                MessageDialog.openError((Shell)shell, (String)HEADER_ENTRY, (String)"The data key must be not empty.");
            } else if (this.well.getData().containsKey(key)) {
                MessageDialog.openError((Shell)shell, (String)HEADER_ENTRY, (String)"The data key already exists.");
            } else if ("".equals(value)) {
                MessageDialog.openError((Shell)shell, (String)HEADER_ENTRY, (String)"The data value must be not empty.");
            } else {
                this.well.setData(key, value);
                this.textHeaderKey.setText("");
                this.textHeaderValue.setText("");
                this.updateHeaderData();
            }
        }
    }

    private void deleteHeaderEntries(Shell shell) {
        MessageBox messageBox = new MessageBox(shell, 196);
        messageBox.setText("Data Entrie(s)");
        messageBox.setMessage("Would you like to delete the selected data entrie(s)?");
        if (messageBox.open() == 64 && this.well != null) {
            Iterator iterator = this.wellDataListUI.getStructuredSelection().iterator();
            HashSet<String> keysNotRemoved = new HashSet<String>();
            while (iterator.hasNext()) {
                Object mapObject = iterator.next();
                if (!(mapObject instanceof Map.Entry)) continue;
                Map.Entry entry = (Map.Entry)mapObject;
                String key = (String)entry.getKey();
                try {
                    this.well.removeData(key);
                }
                catch (InvalidHeaderModificationException e) {
                    keysNotRemoved.add(key);
                }
            }
            if (keysNotRemoved.size() > 0) {
                MessageDialog.openWarning((Shell)DisplayUtils.getShell(), (String)HEADER_ENTRY, (String)("The following keys can't be removed: " + keysNotRemoved));
            }
            this.updateHeaderData();
        }
    }

    private void updateHeaderData() {
        this.updateWidgets();
        this.updateLabel();
        this.wellDataListUI.sortTable();
        Table table = this.wellDataListUI.getTable();
        if (table.getItemCount() > 0) {
            table.setSelection(0);
        }
    }

    private void updateLabel() {
        if (this.well != null) {
            String text = this.well.getLabel();
            String editInformation = this.wellDataListUI.isEditEnabled() ? "Edit is enabled." : "Edit is disabled.";
            this.labelInfoTop.setText(String.valueOf(text) + " - " + editInformation);
            this.labelInfoBottom.setText("Number of Entries: " + this.well.getData().size());
            this.wellDataListUI.setInput(this.well);
        } else {
            this.labelInfoTop.setText("No well data available.");
            this.labelInfoBottom.setText("");
            this.wellDataListUI.setInput(null);
        }
    }

    private void updateWidgets() {
        boolean enabled = this.editable;
        this.buttonToggleEditModus.setEnabled(enabled);
        this.textHeaderKey.setEnabled(enabled);
        this.textHeaderValue.setEnabled(enabled);
        this.buttonAddHeaderEntry.setEnabled(enabled);
        this.buttonDeleteHeaderEntry.setEnabled(enabled);
    }
}

