/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.csd.model.core.IPeakCSD;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ChartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.PeakChartSupport;
import org.eclipse.chemclipse.wsd.model.core.IPeakWSD;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.RangeRestriction;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.exceptions.SeriesException;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;

public class PeakChartUI
extends ScrollableChart {
    private static final float HEIGHT_85 = 0.85f;
    private static final float HEIGHT_50 = 0.5f;
    private static final float HEIGHT_15 = 0.15f;
    private static final float HEIGHT_0 = 0.0f;
    private PeakChartSupport peakChartSupport = new PeakChartSupport();
    private IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();

    public PeakChartUI() {
        this.modifyChart();
    }

    public PeakChartUI(Composite parent, int style) {
        super(parent, style);
        this.modifyChart();
    }

    public void setInput(IPeak peak) {
        this.prepareChart();
        if (peak != null) {
            this.modifyChart(peak);
            List<ILineSeriesData> lineSeriesDataList = this.getPeakSeriesData(peak, false, "");
            this.addLineSeriesData(lineSeriesDataList);
        }
    }

    public void setInput(IPeak peak1, IPeak peak2) {
        this.prepareChart();
        if (peak1 != null) {
            this.modifyChart(peak1);
            ArrayList<ILineSeriesData> lineSeriesDataList = new ArrayList<ILineSeriesData>();
            lineSeriesDataList.addAll(this.getPeakSeriesData(peak1, false, "Peak1"));
            lineSeriesDataList.addAll(this.getPeakSeriesData(peak2, false, "Peak2"));
            this.addLineSeriesData(lineSeriesDataList);
        }
    }

    public void setInput(List<IPeak> peaks) {
        this.prepareChart();
        if (peaks != null && peaks.size() >= 1) {
            this.modifyChart(peaks.get(0));
            ArrayList<ILineSeriesData> lineSeriesDataList = new ArrayList<ILineSeriesData>();
            int i = 0;
            while (i < peaks.size()) {
                IPeak peak = peaks.get(i);
                if (peak != null) {
                    List<ILineSeriesData> lineSeriesDataListPeak = this.getPeakSeriesData(peak, false, Integer.toString(i + 1));
                    lineSeriesDataList.addAll(lineSeriesDataListPeak);
                }
                ++i;
            }
            this.addLineSeriesData(lineSeriesDataList);
        }
    }

    public void setDataType(IChartSettings chartSettings) {
        String titleX = this.preferenceStore.getString("titleXAxisMilliseconds");
        String titleX1 = this.preferenceStore.getString("titleXAxisMinutes");
        String titleY = this.preferenceStore.getString("titleYAxisIntensity");
        String titleY1 = this.preferenceStore.getString("titleYAxisRelativeIntensity");
        ChartSupport.setPrimaryAxisSet(chartSettings, titleX, false, titleY);
        ChartSupport.clearSecondaryAxes(chartSettings);
        ChartSupport.addSecondaryAxisX(chartSettings, titleX1);
        ChartSupport.addSecondaryAxisY(chartSettings, titleY1);
    }

    private List<ILineSeriesData> getPeakSeriesData(IPeak peak, boolean mirrored, String postfix) {
        Color color;
        ArrayList<ILineSeriesData> lineSeriesDataList = new ArrayList<ILineSeriesData>();
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        boolean includeBackground = preferenceStore.getBoolean("showPeakBackground");
        if (preferenceStore.getBoolean("showPeak")) {
            color = Colors.getColor((String)preferenceStore.getString("colorPeak1"));
            lineSeriesDataList.add(this.peakChartSupport.getPeak(peak, includeBackground, mirrored, color, "Peak" + postfix));
        }
        if (preferenceStore.getBoolean("showPeakTangents")) {
            color = Colors.getColor((String)preferenceStore.getString("colorPeakTangents"));
            lineSeriesDataList.add(this.peakChartSupport.getIncreasingTangent(peak, includeBackground, mirrored, color, postfix));
            lineSeriesDataList.add(this.peakChartSupport.getDecreasingTangent(peak, includeBackground, mirrored, color, postfix));
            if (!includeBackground) {
                lineSeriesDataList.add(this.peakChartSupport.getPeakPerpendicular(peak, includeBackground, mirrored, color, postfix));
            }
        }
        if (preferenceStore.getBoolean("showPeakWidth0")) {
            color = Colors.getColor((String)preferenceStore.getString("colorPeakWidth0"));
            lineSeriesDataList.add(this.peakChartSupport.getPeakWidth(peak, includeBackground, 0.0f, mirrored, color, postfix));
        }
        if (preferenceStore.getBoolean("showPeakWidth50")) {
            color = Colors.getColor((String)preferenceStore.getString("colorPeakWidth50"));
            lineSeriesDataList.add(this.peakChartSupport.getPeakWidth(peak, includeBackground, 0.5f, mirrored, color, postfix));
        }
        if (preferenceStore.getBoolean("showPeakWidthCondalBosh")) {
            color = Colors.getColor((String)preferenceStore.getString("colorPeakWidthCondalBosh"));
            lineSeriesDataList.add(this.peakChartSupport.getPeakWidth(peak, includeBackground, 0.85f, mirrored, color, postfix));
            lineSeriesDataList.add(this.peakChartSupport.getPeakWidth(peak, includeBackground, 0.15f, mirrored, color, postfix));
        }
        if (includeBackground) {
            if (preferenceStore.getBoolean("showPeakBaseline")) {
                color = Colors.getColor((String)preferenceStore.getString("colorPeakBaseline"));
                lineSeriesDataList.add(this.peakChartSupport.getPeakBaseline(peak, mirrored, color, "Peak Baseline" + postfix));
            }
            color = Colors.getColor((String)preferenceStore.getString("colorPeakBackground"));
            lineSeriesDataList.add(this.peakChartSupport.getPeakBackground(peak, mirrored, color, "Peak Background" + postfix));
        }
        return lineSeriesDataList;
    }

    private void prepareChart() {
        this.deleteSeries();
    }

    private void modifyChart() {
        IChartSettings chartSettings = this.getChartSettings();
        chartSettings.setCreateMenu(true);
        RangeRestriction rangeRestriction = chartSettings.getRangeRestriction();
        rangeRestriction.setRestrictZoom(true);
        rangeRestriction.setExtendTypeY(RangeRestriction.ExtendType.RELATIVE);
        rangeRestriction.setExtendMinY(0.0);
        rangeRestriction.setExtendMaxY(0.1);
        this.applySettings(chartSettings);
    }

    private void modifyChart(IPeak peak) {
        IChartSettings chartSettings = this.getChartSettings();
        if (peak instanceof IPeakMSD) {
            this.setDataType(chartSettings);
        } else if (peak instanceof IPeakCSD) {
            this.setDataType(chartSettings);
        } else if (peak instanceof IPeakWSD) {
            this.setDataType(chartSettings);
        }
        this.applySettings(chartSettings);
    }

    private void addLineSeriesData(List<ILineSeriesData> lineSeriesDataList) {
        if (lineSeriesDataList != null && lineSeriesDataList.size() > 0) {
            BaseChart baseChart = this.getBaseChart();
            baseChart.suspendUpdate(true);
            for (ILineSeriesData lineSeriesData : lineSeriesDataList) {
                try {
                    ISeriesData seriesData = lineSeriesData.getSeriesData();
                    ISeriesData optimizedSeriesData = this.calculateSeries(seriesData);
                    ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
                    lineSeriesSettings.getSeriesSettingsHighlight();
                    ILineSeries lineSeries = (ILineSeries)this.createSeries(optimizedSeriesData, (ISeriesSettings)lineSeriesSettings);
                    baseChart.applyLineSeriesSettings(lineSeries, lineSeriesSettings);
                }
                catch (SeriesException seriesException) {
                    // empty catch block
                }
            }
            baseChart.suspendUpdate(false);
            this.adjustRange(true);
            baseChart.redraw();
        }
    }
}

