/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.chemclipse.model.core.IComplexSignalMeasurement;
import org.eclipse.chemclipse.model.core.PeakList;
import org.eclipse.chemclipse.nmr.model.core.AcquisitionParameter;
import org.eclipse.chemclipse.nmr.model.core.FIDMeasurement;
import org.eclipse.chemclipse.nmr.model.core.SpectrumMeasurement;
import org.eclipse.chemclipse.nmr.model.selection.IDataNMRSelection;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.xxd.ui.charts.ChartNMR;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.extensions.core.AbstractAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;
import org.eclipse.swtchart.extensions.linecharts.LineSeriesData;

public class ExtendedNMRScanUI
implements Observer {
    private static final String SERIES_ID = "NMR";
    private ChartNMR chartNMR;
    private IDataNMRSelection dataNMRSelection;

    public ExtendedNMRScanUI(Composite parent) {
        this.chartNMR = new ChartNMR(parent, 0, () -> this.dataNMRSelection.getMeasurement());
        IChartSettings chartSettings = this.chartNMR.getChartSettings();
        chartSettings.setCreateMenu(true);
        chartSettings.setEnableRangeSelector(false);
        chartSettings.setShowRangeSelectorInitially(false);
        this.chartNMR.applySettings(chartSettings);
    }

    public void update(IDataNMRSelection scanNMR) {
        if (this.dataNMRSelection != null) {
            this.dataNMRSelection.removeObserver((Observer)this);
        }
        this.dataNMRSelection = scanNMR;
        this.updateScan();
        scanNMR.addObserver((Observer)this);
    }

    public void suspendUpdate(boolean suspend) {
        this.chartNMR.getBaseChart().suspendUpdate(suspend);
    }

    public void updateScan() {
        boolean wasSuspend = this.chartNMR.getBaseChart().isUpdateSuspended();
        if (!wasSuspend) {
            this.suspendUpdate(true);
        }
        try {
            this.chartNMR.deleteSeries();
            if (this.dataNMRSelection != null) {
                boolean enableArea;
                AcquisitionParameter acquisitionParameter;
                IComplexSignalMeasurement<?> measurement = this.getCurrentMeasurement();
                ISeriesData peakSeriesData = null;
                if (measurement instanceof SpectrumMeasurement) {
                    SpectrumMeasurement spectrumMeasurement = (SpectrumMeasurement)measurement;
                    acquisitionParameter = spectrumMeasurement.getAcquisitionParameter();
                    this.chartNMR.setPPMconverter((IAxisScaleConverter)new AbstractAxisScaleConverter(){

                        public double convertToSecondaryUnit(double primaryValue) {
                            return acquisitionParameter.toPPM(BigDecimal.valueOf(primaryValue)).doubleValue();
                        }

                        public double convertToPrimaryUnit(double secondaryValue) {
                            return acquisitionParameter.toHz(BigDecimal.valueOf(secondaryValue)).doubleValue();
                        }
                    });
                    this.chartNMR.modifyChart(false);
                    enableArea = true;
                    PeakList peakList = (PeakList)spectrumMeasurement.getMeasurementResult(PeakList.class);
                    if (peakList != null) {
                        peakSeriesData = ChartNMR.createPeakSeries("NMR.peaks", spectrumMeasurement.getSignals(), peakList.getResult(), 0.0, 0.0);
                    }
                } else if (measurement instanceof FIDMeasurement) {
                    acquisitionParameter = ((FIDMeasurement)measurement).getAcquisitionParameter();
                    this.chartNMR.setPPMconverter(null);
                    this.chartNMR.modifyChart(true);
                    enableArea = false;
                } else {
                    this.chartNMR.setPPMconverter(null);
                    return;
                }
                ArrayList<LineSeriesData> lineSeriesDataList = new ArrayList<LineSeriesData>();
                LineSeriesData lineSeriesData = new LineSeriesData(ChartNMR.createSignalSeries(SERIES_ID, measurement.getSignals()));
                if (Boolean.getBoolean("editor.nmr.debug.seriesdata")) {
                    System.out.println("============ " + measurement.getDataName() + " ==================");
                    AcquisitionParameter.print((AcquisitionParameter)acquisitionParameter);
                    ISeriesData data = lineSeriesData.getSeriesData();
                    double[] xSeries = data.getXSeries();
                    double[] ySeries = data.getYSeries();
                    int i = 0;
                    while (i < xSeries.length) {
                        if (i < 100 || i > xSeries.length - 100) {
                            System.out.println("[" + i + "] time = " + xSeries[i] + ", signal = " + ySeries[i]);
                        }
                        ++i;
                    }
                }
                ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
                lineSeriesSettings.setEnableArea(enableArea);
                lineSeriesSettings.setLineColor(Colors.RED);
                lineSeriesDataList.add(lineSeriesData);
                if (peakSeriesData != null) {
                    LineSeriesData peakSeries = new LineSeriesData(peakSeriesData);
                    lineSeriesDataList.add(peakSeries);
                    ILineSeriesSettings settings = peakSeries.getLineSeriesSettings();
                    settings.setLineStyle(LineStyle.NONE);
                    settings.setSymbolType(ILineSeries.PlotSymbolType.INVERTED_TRIANGLE);
                    settings.setSymbolColor(Colors.BLACK);
                    settings.setSymbolSize(3);
                }
                this.chartNMR.addSeriesData(lineSeriesDataList);
            }
        }
        finally {
            if (!wasSuspend) {
                this.suspendUpdate(false);
            }
        }
    }

    private IComplexSignalMeasurement<?> getCurrentMeasurement() {
        return this.dataNMRSelection.getMeasurement();
    }

    public Control getControl() {
        return this.chartNMR;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg == IDataNMRSelection.ChangeType.SELECTION_CHANGED) {
            Display.getDefault().asyncExec(this::updateScan);
        }
    }
}

