/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors;

import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.selection.ChromatogramSelectionSupport;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.selection.MoveDirection;
import org.eclipse.chemclipse.support.ui.addons.ModelSupportAddon;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors.ExtendedChromatogramUI;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.events.AbstractHandledEventProcessor;
import org.eclipse.swtchart.extensions.events.IHandledEventProcessor;

public class ScanSelectionArrowKeyHandler
extends AbstractHandledEventProcessor
implements IHandledEventProcessor {
    private ExtendedChromatogramUI extendedChromatogramUI;
    private int keyCode;

    public ScanSelectionArrowKeyHandler(ExtendedChromatogramUI extendedChromatogramUI, int keyCode) {
        this.extendedChromatogramUI = extendedChromatogramUI;
        this.keyCode = keyCode;
    }

    public int getEvent() {
        return 7;
    }

    public int getButton() {
        return this.keyCode;
    }

    public int getStateMask() {
        return 262144;
    }

    public void handleEvent(BaseChart baseChart, Event event) {
        this.handleControlScanSelection(this.keyCode);
    }

    protected void handleControlScanSelection(int keyCode) {
        IChromatogramSelection chromatogramSelection = this.extendedChromatogramUI.getChromatogramSelection();
        if (chromatogramSelection != null) {
            int scanNumber = chromatogramSelection.getSelectedScan().getScanNumber();
            scanNumber = keyCode == 0x1000004 ? ++scanNumber : --scanNumber;
            IScan selectedScan = chromatogramSelection.getChromatogram().getScan(scanNumber);
            IEventBroker eventBroker = ModelSupportAddon.getEventBroker();
            eventBroker.send("scan/xxd/update/selection", (Object)selectedScan);
            if (selectedScan != null) {
                int scanRetentionTime = selectedScan.getRetentionTime();
                int startRetentionTime = chromatogramSelection.getStartRetentionTime();
                int stopRetentionTime = chromatogramSelection.getStopRetentionTime();
                if (scanRetentionTime <= startRetentionTime) {
                    ChromatogramSelectionSupport.moveRetentionTimeWindow((IChromatogramSelection)chromatogramSelection, (MoveDirection)MoveDirection.LEFT, (int)5);
                } else if (scanRetentionTime >= stopRetentionTime) {
                    ChromatogramSelectionSupport.moveRetentionTimeWindow((IChromatogramSelection)chromatogramSelection, (MoveDirection)MoveDirection.RIGHT, (int)5);
                }
                chromatogramSelection.setSelectedScan(selectedScan, false);
                this.extendedChromatogramUI.updateSelection();
            }
        }
    }
}

