/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.scanremover.settings;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.scanremover.preferences.PreferenceSupplier;

public class ScanRemoverPattern {
    private List<Boolean> patternRemove;
    private int position;

    public ScanRemoverPattern(String scanRemoverPattern) {
        if (scanRemoverPattern == null) {
            scanRemoverPattern = "";
        }
        this.init(scanRemoverPattern);
    }

    public boolean remove() {
        int index = this.getActualIndex();
        ++this.position;
        boolean removeScan = false;
        if (this.patternRemove.size() > 0) {
            removeScan = this.patternRemove.get(index);
        }
        return removeScan;
    }

    private void init(String scanRemoverPattern) {
        this.patternRemove = new ArrayList<Boolean>();
        this.position = 0;
        scanRemoverPattern = scanRemoverPattern.toUpperCase();
        char[] chars = scanRemoverPattern.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char removerChar = chars[i];
            if (removerChar == PreferenceSupplier.PRESERVE_SIGN.charValue()) {
                this.patternRemove.add(false);
            } else if (removerChar == PreferenceSupplier.REMOVE_SIGN.charValue()) {
                this.patternRemove.add(true);
            }
            ++i;
        }
    }

    private int getActualIndex() {
        if (this.position < 0 || this.position >= this.patternRemove.size()) {
            this.position = 0;
        }
        return this.position;
    }
}

