/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.chromatogram.msd.filter.settings.IMassSpectrumFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.Activator;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.settings.ChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.settings.MassSpectrumFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.settings.PeakFilterSettings;
import org.eclipse.chemclipse.support.preferences.IPreferenceSupplier;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class PreferenceSupplier
implements IPreferenceSupplier {
    public static final String P_IONS_TO_REMOVE = "ionsToRemove";
    public static final String DEF_IONS_TO_REMOVE = "18;28;84;207";
    private static IPreferenceSupplier preferenceSupplier;

    public static IPreferenceSupplier INSTANCE() {
        if (preferenceSupplier == null) {
            preferenceSupplier = new PreferenceSupplier();
        }
        return preferenceSupplier;
    }

    public IScopeContext getScopeContext() {
        return InstanceScope.INSTANCE;
    }

    public String getPreferenceNode() {
        return Activator.getContext().getBundle().getSymbolicName();
    }

    public Map<String, String> getDefaultValues() {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        defaultValues.put(P_IONS_TO_REMOVE, DEF_IONS_TO_REMOVE);
        return defaultValues;
    }

    public IEclipsePreferences getPreferences() {
        return this.getScopeContext().getNode(this.getPreferenceNode());
    }

    public static ChromatogramFilterSettings getFilterSettings() {
        ChromatogramFilterSettings filterSettings = new ChromatogramFilterSettings();
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        filterSettings.setIonsToRemove(preferences.get(P_IONS_TO_REMOVE, DEF_IONS_TO_REMOVE));
        return filterSettings;
    }

    public static PeakFilterSettings getPeakFilterSettings() {
        PeakFilterSettings peakFilterSettings = new PeakFilterSettings();
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        peakFilterSettings.setIonsToRemove(preferences.get(P_IONS_TO_REMOVE, DEF_IONS_TO_REMOVE));
        return peakFilterSettings;
    }

    public static IMassSpectrumFilterSettings getMassSpectrumFilterSettings() {
        MassSpectrumFilterSettings massSpectrumFilterSettings = new MassSpectrumFilterSettings();
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        massSpectrumFilterSettings.setIonsToRemove(preferences.get(P_IONS_TO_REMOVE, DEF_IONS_TO_REMOVE));
        return massSpectrumFilterSettings;
    }
}

