/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.core;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.IProcessingResult;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;

public class DefaultProcessingResult<T>
implements IProcessingResult<T> {
    private List<IProcessingMessage> processingMessages = new ArrayList<IProcessingMessage>();
    private T processingResult;

    public DefaultProcessingResult() {
    }

    public DefaultProcessingResult(IProcessingResult<T> processingInfo) {
        this();
        this.addMessages(processingInfo);
    }

    @Override
    public void addMessage(IProcessingMessage processingMessage) {
        this.processingMessages.add(processingMessage);
    }

    @Override
    public List<IProcessingMessage> getMessages() {
        return this.processingMessages;
    }

    @Override
    public List<IProcessingMessage> getMessages(MessageType type) {
        return this.getMessages().stream().filter(m -> m.getMessageType().equals((Object)type)).collect(Collectors.toList());
    }

    @Override
    public T getProcessingResult() {
        return this.processingResult;
    }

    @Override
    public void setProcessingResult(T processingResult) {
        this.processingResult = processingResult;
    }

    @Override
    public IProcessingInfo<T> toInfo() {
        ProcessingInfo<T> result = new ProcessingInfo<T>();
        for (IProcessingMessage message : this.getMessages()) {
            result.addMessage(message);
        }
        result.setProcessingResult(this.getProcessingResult());
        return result;
    }
}

