/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.procedures.Procedure;
import org.eclipse.chemclipse.processing.supplier.AbstractProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.ExecutionResultTransformer;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionConsumer;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionContext;
import org.eclipse.chemclipse.processing.supplier.ProcessSupplierContext;
import org.eclipse.chemclipse.processing.supplier.ProcessorPreferences;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

public class ProcedureProcessTypeSupplier
implements IProcessTypeSupplier {
    private ProcessSupplierContext context;
    private final List<Procedure<?>> procedures = new CopyOnWriteArrayList();

    @Override
    public String getCategory() {
        return "Procedures";
    }

    @Override
    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        ArrayList list = new ArrayList();
        for (Procedure<?> procedure : this.procedures) {
            list.add(new ProcedureProcessSupplier(procedure));
        }
        return list;
    }

    @Reference(unbind="-")
    public void setProcessSupplierContext(ProcessSupplierContext context) {
        this.context = context;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addProcedure(Procedure<?> procedure) {
        this.procedures.add(procedure);
    }

    public void removeProcedure(Procedure<?> procedure) {
        this.procedures.remove(procedure);
    }

    private final class ProcedureProcessSupplier<ConfigType>
    extends AbstractProcessSupplier<ConfigType>
    implements ProcessSupplierContext,
    ExecutionResultTransformer<ConfigType> {
        private final Procedure<ConfigType> procedure;

        public ProcedureProcessSupplier(Procedure<ConfigType> procedure) {
            super(procedure.getID(), procedure.getName(), procedure.getDescription(), procedure.getConfigClass(), ProcedureProcessTypeSupplier.this, procedure.getDataCategories());
            this.procedure = procedure;
        }

        @Override
        public IProcessSupplier.SupplierType getType() {
            return IProcessSupplier.SupplierType.STRUCTURAL;
        }

        @Override
        public <T> IProcessSupplier<T> getSupplier(String id) {
            IProcessSupplier supplier = ProcedureProcessTypeSupplier.this.context.getSupplier(id);
            if (supplier != null && this.accepts(supplier)) {
                return supplier;
            }
            return null;
        }

        @Override
        public void visitSupplier(Consumer<? super IProcessSupplier<?>> consumer) {
            ProcedureProcessTypeSupplier.this.context.getSupplier(this::accepts).forEach(consumer);
        }

        private boolean accepts(IProcessSupplier<?> supplier) {
            Set<DataCategory> supportedDataTypes = supplier.getSupportedDataTypes();
            DataCategory[] dataCategoryArray = this.procedure.getDataCategories();
            int n = dataCategoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataCategory category = dataCategoryArray[n2];
                if (supportedDataTypes.contains((Object)category)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        public <T> ProcessExecutionConsumer<T> transform(ProcessExecutionConsumer<T> consumer, ProcessorPreferences<ConfigType> processorPreferences, ProcessExecutionContext context) throws IOException {
            ProcessExecutionConsumer<T> executionConsumer = this.procedure.createConsumer(processorPreferences.getSettings(), consumer, context);
            if (executionConsumer == null) {
                return consumer;
            }
            return executionConsumer;
        }
    }
}

