/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.peakmax.ui.internal.handler;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.peakmax.ui.internal.handler.PeakIntegrationSettingsSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.peaks.PeakIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.IPeakIntegrationSettings;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class PeakIntegratorRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(PeakIntegratorRunnable.class);
    private static final String PEAK_INTEGRATOR_ID = "org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.peakmax.peakIntegrator";
    private IChromatogramSelectionMSD chromatogramSelection;

    public PeakIntegratorRunnable(IChromatogramSelectionMSD chromatogramSelection) {
        this.chromatogramSelection = chromatogramSelection;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            PeakIntegrationSettingsSupport peakIntegrationSettingsSupport = new PeakIntegrationSettingsSupport();
            IPeakIntegrationSettings peakIntegrationSettings = peakIntegrationSettingsSupport.getPeakIntegrationSettings();
            IProcessingInfo processingInfo = PeakIntegrator.integrate((IChromatogramSelection)this.chromatogramSelection, (IPeakIntegrationSettings)peakIntegrationSettings, (String)PEAK_INTEGRATOR_ID, (IProgressMonitor)monitor);
            ProcessingInfoViewSupport.updateProcessingInfo((MessageProvider)processingInfo, (boolean)false);
            this.chromatogramSelection.update(false);
        }
        finally {
            monitor.done();
        }
    }
}

