/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.core.chromatogram;

import org.eclipse.chemclipse.chromatogram.filter.result.IChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.chromatogram.ChromatogramFilterSupplierMSD;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.chromatogram.ChromatogramFilterSupportMSD;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.chromatogram.IChromatogramFilterMSD;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.chromatogram.IChromatogramFilterSupportMSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class ChromatogramFilterMSD {
    private static final Logger logger = Logger.getLogger(ChromatogramFilterMSD.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.chromatogram.msd.filter.chromatogramFilterSupplier";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String FILTER_NAME = "filterName";
    private static final String FILTER = "filter";
    private static final String FILTER_SETTINGS = "filterSettings";
    private static final String PROCESSING_DESCRIPTION = "Chromatogram Filter MSD";
    private static final String NO_CHROMATOGRAM_FILTER_AVAILABLE = "There is no chromatogram filter available.";

    private ChromatogramFilterMSD() {
    }

    public static IProcessingInfo applyFilter(IChromatogramSelectionMSD chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings, String filterId, IProgressMonitor monitor) {
        IProcessingInfo processingInfo;
        IChromatogramFilterMSD chromatogramFilter = ChromatogramFilterMSD.getChromatogramFilter(filterId);
        if (chromatogramFilter != null) {
            processingInfo = chromatogramFilter.applyFilter(chromatogramSelection, chromatogramFilterSettings, monitor);
        } else {
            processingInfo = new IProcessingInfo();
            processingInfo.addErrorMessage(PROCESSING_DESCRIPTION, NO_CHROMATOGRAM_FILTER_AVAILABLE);
        }
        return processingInfo;
    }

    public static IProcessingInfo<IChromatogramFilterResult> applyFilter(IChromatogramSelectionMSD chromatogramSelection, String filterId, IProgressMonitor monitor) {
        IProcessingInfo processingInfo;
        IChromatogramFilterMSD chromatogramFilter = ChromatogramFilterMSD.getChromatogramFilter(filterId);
        if (chromatogramFilter != null) {
            processingInfo = chromatogramFilter.applyFilter(chromatogramSelection, monitor);
        } else {
            processingInfo = new IProcessingInfo();
            processingInfo.addErrorMessage(PROCESSING_DESCRIPTION, NO_CHROMATOGRAM_FILTER_AVAILABLE);
        }
        return processingInfo;
    }

    public static IChromatogramFilterSupportMSD getChromatogramFilterSupport() {
        IConfigurationElement[] extensions;
        ChromatogramFilterSupportMSD filterSupport = new ChromatogramFilterSupportMSD();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            ChromatogramFilterSupplierMSD supplier = new ChromatogramFilterSupplierMSD();
            supplier.setId(element.getAttribute(ID));
            supplier.setDescription(element.getAttribute(DESCRIPTION));
            supplier.setFilterName(element.getAttribute(FILTER_NAME));
            if (element.getAttribute(FILTER_SETTINGS) != null) {
                try {
                    IChromatogramFilterSettings instance = (IChromatogramFilterSettings)element.createExecutableExtension(FILTER_SETTINGS);
                    supplier.setSettingsClass(instance.getClass());
                }
                catch (CoreException e) {
                    logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    supplier.setSettingsClass(null);
                }
            }
            filterSupport.add(supplier);
            ++n2;
        }
        return filterSupport;
    }

    private static IChromatogramFilterMSD getChromatogramFilter(String filterId) {
        IConfigurationElement element = ChromatogramFilterMSD.getConfigurationElement(filterId);
        IChromatogramFilterMSD instance = null;
        if (element != null) {
            try {
                instance = (IChromatogramFilterMSD)element.createExecutableExtension(FILTER);
            }
            catch (CoreException e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String filterId) {
        IConfigurationElement[] elements;
        if ("".equals(filterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute(ID).equals(filterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }
}

