/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum;

import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum.IMassSpectrumFilter;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum.IMassSpectrumFilterSupport;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum.MassSpectrumFilterSupplier;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum.MassSpectrumFilterSupport;
import org.eclipse.chemclipse.chromatogram.msd.filter.result.IMassSpectrumFilterResult;
import org.eclipse.chemclipse.chromatogram.msd.filter.settings.IMassSpectrumFilterSettings;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class MassSpectrumFilter {
    private static final Logger logger = Logger.getLogger(MassSpectrumFilter.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.chromatogram.msd.filter.massSpectrumFilterSupplier";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String FILTER_NAME = "filterName";
    private static final String FILTER = "filter";
    private static final String FILTER_CONFIG = "config";
    private static final String PROCESSING_DESCRIPTION = "Mass Spectrum Filter";
    private static final String NO_MASS_SPECTRUM_FILTER_AVAILABLE = "There is no mass spectrum filter available.";

    private MassSpectrumFilter() {
    }

    public static IProcessingInfo<IMassSpectrumFilterResult> applyFilter(IScanMSD massSpectrum, IMassSpectrumFilterSettings massSpectrumFilterSettings, String filterId, IProgressMonitor monitor) {
        return MassSpectrumFilter.applyFilter(Collections.singletonList(massSpectrum), massSpectrumFilterSettings, filterId, monitor);
    }

    public static IProcessingInfo<IMassSpectrumFilterResult> applyFilter(IScanMSD massSpectrum, String filterId, IProgressMonitor monitor) {
        return MassSpectrumFilter.applyFilter(Collections.singletonList(massSpectrum), null, filterId, monitor);
    }

    public static IProcessingInfo<IMassSpectrumFilterResult> applyFilter(List<IScanMSD> massSpectra, IMassSpectrumFilterSettings massSpectraFilterSettings, String filterId, IProgressMonitor monitor) {
        IProcessingInfo<IMassSpectrumFilterResult> processingInfo;
        IMassSpectrumFilter massSpectrumFilter = MassSpectrumFilter.getMassSpectrumFilter(filterId);
        if (massSpectrumFilter != null) {
            processingInfo = massSpectrumFilter.applyFilter(massSpectra, massSpectraFilterSettings, monitor);
        } else {
            processingInfo = new IProcessingInfo<IMassSpectrumFilterResult>();
            processingInfo.addErrorMessage(PROCESSING_DESCRIPTION, NO_MASS_SPECTRUM_FILTER_AVAILABLE);
        }
        return processingInfo;
    }

    public static IProcessingInfo<IMassSpectrumFilterResult> applyFilter(List<IScanMSD> massSpectra, String filterId, IProgressMonitor monitor) {
        return MassSpectrumFilter.applyFilter(massSpectra, null, filterId, monitor);
    }

    public static IMassSpectrumFilterSupport getMassSpectrumFilterSupport() {
        IConfigurationElement[] extensions;
        MassSpectrumFilterSupport filterSupport = new MassSpectrumFilterSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            MassSpectrumFilterSupplier supplier = new MassSpectrumFilterSupplier();
            supplier.setId(element.getAttribute(ID));
            supplier.setDescription(element.getAttribute(DESCRIPTION));
            supplier.setFilterName(element.getAttribute(FILTER_NAME));
            try {
                supplier.setConfigClass(element.createExecutableExtension(FILTER_CONFIG).getClass().asSubclass(IMassSpectrumFilterSettings.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
            filterSupport.add(supplier);
            ++n2;
        }
        return filterSupport;
    }

    private static IMassSpectrumFilter getMassSpectrumFilter(String filterId) {
        IConfigurationElement element = MassSpectrumFilter.getConfigurationElement(filterId);
        IMassSpectrumFilter instance = null;
        if (element != null) {
            try {
                instance = (IMassSpectrumFilter)element.createExecutableExtension(FILTER);
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String filterId) {
        IConfigurationElement[] elements;
        if ("".equals(filterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute(ID).equals(filterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }
}

