/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum.AbstractMassspectrumFilterProcessTypeSupplier;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.osgi.service.component.annotations.Component;

@Component(service={IProcessTypeSupplier.class})
public class PeakMassspectrumFilterProcessTypeSupplier
extends AbstractMassspectrumFilterProcessTypeSupplier {
    public PeakMassspectrumFilterProcessTypeSupplier() {
        super("Peak Massspectrum Filter", "mzfilter.msd.peak.", new Function<IChromatogramSelection<?, ?>, List<IScanMSD>>(){

            @Override
            public List<IScanMSD> apply(IChromatogramSelection<?, ?> chromatogramSelection) {
                ArrayList<IScanMSD> massspectras = new ArrayList<IScanMSD>();
                List peaks = chromatogramSelection.getChromatogram().getPeaks(chromatogramSelection);
                for (Object object : peaks) {
                    if (!(object instanceof IPeakMSD)) continue;
                    massspectras.add((IScanMSD)((IPeakMSD)object).getExtractedMassSpectrum());
                }
                return massspectras;
            }
        });
    }
}

