/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.impl;

import org.eclipse.chemclipse.chromatogram.filter.result.ChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.chromatogram.AbstractChromatogramFilterMSD;
import org.eclipse.chemclipse.chromatogram.msd.filter.impl.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.filter.impl.settings.FilterSettingsAdjust;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.matrix.ExtractedMatrix;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramFilterZeroValueRemoval
extends AbstractChromatogramFilterMSD {
    private static final Logger logger = Logger.getLogger(ChromatogramFilterZeroValueRemoval.class);

    public IProcessingInfo applyFilter(IChromatogramSelectionMSD chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = this.validate(chromatogramSelection, chromatogramFilterSettings);
        if (!processingInfo.hasErrorMessages() && chromatogramFilterSettings instanceof FilterSettingsAdjust) {
            if (chromatogramSelection instanceof IChromatogramSelectionMSD) {
                IChromatogramSelectionMSD chromatogramSelectionMSD = chromatogramSelection;
                ExtractedMatrix extract = new ExtractedMatrix(chromatogramSelectionMSD);
                double[][] matrix = extract.getMatrix();
                int numberIons = matrix[0].length;
                int numberScans = matrix.length;
                int ionIndex = 0;
                while (ionIndex < numberIons) {
                    int startIndex = 0;
                    int scanIndex = 0;
                    while (scanIndex < numberScans) {
                        if (matrix[scanIndex][ionIndex] != 0.0) {
                            startIndex = scanIndex;
                            break;
                        }
                        ++scanIndex;
                    }
                    scanIndex = startIndex;
                    while (scanIndex < numberScans) {
                        if (matrix[scanIndex][ionIndex] != 0.0) {
                            if (scanIndex == startIndex + 1) {
                                startIndex = scanIndex;
                            } else {
                                matrix = this.linearInterpolation(matrix, startIndex, scanIndex, ionIndex);
                                startIndex = scanIndex;
                            }
                        }
                        ++scanIndex;
                    }
                    ++ionIndex;
                }
                extract.updateSignal();
            }
            processingInfo.setProcessingResult((Object)new ChromatogramFilterResult(ResultStatus.OK, "Chromatogram Filter Adjust applied"));
        }
        return processingInfo;
    }

    private double[][] linearInterpolation(double[][] matrix, int startColumn, int stopColumn, int row) {
        double startSignal = matrix[startColumn][row];
        double stopSignal = matrix[stopColumn][row];
        int index = 1;
        while (index < stopColumn - startColumn) {
            matrix[startColumn + index][row] = (stopSignal - startSignal) / (double)(stopColumn - startColumn) * (double)index + startSignal;
            ++index;
        }
        return matrix;
    }

    public IProcessingInfo applyFilter(IChromatogramSelectionMSD chromatogramSelection, IProgressMonitor monitor) {
        FilterSettingsAdjust filterSettings = PreferenceSupplier.getFilterSettingsAdjust();
        return this.applyFilter(chromatogramSelection, (IChromatogramFilterSettings)filterSettings, monitor);
    }
}

