/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.nmr.model.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.model.core.FilteredMeasurement;
import org.eclipse.chemclipse.nmr.model.core.AcquisitionParameter;
import org.eclipse.chemclipse.nmr.model.core.SpectrumMeasurement;
import org.eclipse.chemclipse.nmr.model.core.SpectrumSignal;
import org.eclipse.chemclipse.processing.filter.FilterContext;

public class FilteredSpectrumMeasurement<ConfigType>
extends FilteredMeasurement<SpectrumMeasurement, ConfigType>
implements SpectrumMeasurement {
    private static final long serialVersionUID = -4028057722405624626L;
    private transient List<? extends SpectrumSignal> signals;

    public FilteredSpectrumMeasurement(FilterContext<SpectrumMeasurement, ConfigType> context) {
        super(context);
    }

    @Override
    public List<? extends SpectrumSignal> getSignals() {
        if (this.signals != null) {
            return this.signals;
        }
        return ((SpectrumMeasurement)this.getFilteredObject()).getSignals();
    }

    public void setSignals(List<? extends SpectrumSignal> signals) {
        this.signals = signals;
    }

    @Override
    public final AcquisitionParameter getAcquisitionParameter() {
        return ((SpectrumMeasurement)this.getFilteredObject()).getAcquisitionParameter();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.signals == null) {
            out.writeObject(null);
        } else {
            ArrayList<SpectrumSignal> serList = new ArrayList<SpectrumSignal>(this.signals.size());
            for (SpectrumSignal spectrumSignal : this.signals) {
                if (spectrumSignal instanceof Serializable) {
                    serList.add(spectrumSignal);
                    continue;
                }
                serList.add(new SerializableSpectrumSignal(spectrumSignal));
            }
            out.writeObject(serList);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.signals = (List)in.readObject();
    }

    private static final class SerializableSpectrumSignal
    implements SpectrumSignal,
    Serializable {
        private static final long serialVersionUID = -5726100506736511582L;
        private BigDecimal frequency;
        private Number absorptiveIntensity;
        private Number dispersiveIntensity;

        public SerializableSpectrumSignal(SpectrumSignal copyfrom) {
            this.frequency = copyfrom.getFrequency();
            this.absorptiveIntensity = copyfrom.getAbsorptiveIntensity();
            this.dispersiveIntensity = copyfrom.getDispersiveIntensity();
        }

        @Override
        public BigDecimal getFrequency() {
            return this.frequency;
        }

        @Override
        public Number getAbsorptiveIntensity() {
            return this.absorptiveIntensity;
        }

        @Override
        public Number getDispersiveIntensity() {
            return this.dispersiveIntensity;
        }
    }
}

