/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.swt.edit;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.swt.ControlBuilder;
import org.eclipse.chemclipse.support.ui.swt.columns.ColumnDefinitionProvider;
import org.eclipse.chemclipse.support.ui.swt.edit.EditValue;
import org.eclipse.chemclipse.support.ui.swt.edit.ListEditModel;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ListEdit<V>
extends EditValue<List<V>> {
    private final TableViewer tableViewer;
    private final List<V> initialValues = new ArrayList<V>();
    private final List<V> currentValues = new CopyOnWriteArrayList<V>();
    private final Action addAction;
    private final Action deleteAction;
    private final Action editAction;
    private boolean edited;

    public ListEdit(Composite parent, ColumnDefinitionProvider columnDefinitionProvider, final ListEditModel<V> editModel) {
        Composite container = ControlBuilder.createContainer(parent, 2);
        ControlBuilder.gridData((Control)container).heightHint = 200;
        this.tableViewer = ControlBuilder.createTable(container, false);
        ControlBuilder.maximize(this.tableViewer.getControl());
        this.initialValues.addAll(editModel.list());
        this.currentValues.addAll(this.initialValues);
        ControlBuilder.createColumns(this.tableViewer, columnDefinitionProvider, false);
        this.tableViewer.setInput(this.currentValues);
        ToolBarManager toolbar = new ToolBarManager(512);
        this.addAction = new Action("Add", ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/add.gif", "16x16")){

            public void run() {
                Object newItem = editModel.create();
                if (newItem != null) {
                    ListEdit.this.currentValues.add(newItem);
                    ListEdit.this.tableViewer.refresh();
                    ListEdit.this.setChanged();
                    ListEdit.this.notifyObservers(ListEdit.this.currentValues);
                }
                ListEdit.this.updateButtons(editModel);
            }
        };
        this.deleteAction = new Action("Remove", ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/remove.gif", "16x16")){

            public void run() {
                Object[] array;
                boolean changed = false;
                Object[] objectArray = array = ListEdit.this.tableViewer.getStructuredSelection().toArray();
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (ListEdit.this.currentValues.remove(object)) {
                        editModel.delete(object);
                        changed = true;
                    }
                    ++n2;
                }
                if (changed) {
                    ListEdit.this.tableViewer.refresh();
                    ListEdit.this.setChanged();
                    ListEdit.this.notifyObservers(ListEdit.this.currentValues);
                }
                ListEdit.this.updateButtons(editModel);
            }
        };
        this.editAction = new Action("Remove", ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/edit.gif", "16x16")){

            public void run() {
                Object element = ListEdit.this.tableViewer.getStructuredSelection().getFirstElement();
                if (element != null && editModel.edit(element)) {
                    ListEdit.this.edited = true;
                    ListEdit.this.tableViewer.refresh();
                    ListEdit.this.setChanged();
                    ListEdit.this.notifyObservers(ListEdit.this.currentValues);
                }
                ListEdit.this.updateButtons(editModel);
            }
        };
        this.updateButtons(editModel);
        toolbar.add((IAction)this.addAction);
        toolbar.add((IAction)this.editAction);
        toolbar.add((IAction)this.deleteAction);
        ControlBuilder.gridData((Control)toolbar.createControl((Composite)container)).verticalAlignment = 128;
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent sce) {
                ListEdit.this.deleteAction.setEnabled(!ListEdit.this.tableViewer.getStructuredSelection().isEmpty());
            }
        });
    }

    private void updateButtons(ListEditModel<V> editModel) {
        this.addAction.setEnabled(editModel.canCreate());
        IStructuredSelection selection = this.getTableViewer().getStructuredSelection();
        if (selection.isEmpty()) {
            this.deleteAction.setEnabled(false);
            this.editAction.setEnabled(false);
        } else {
            Object[] array;
            boolean canDelete = true;
            Object[] objectArray = array = selection.toArray();
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (canDelete && !editModel.canDelete(o)) {
                    canDelete = false;
                    break;
                }
                ++n2;
            }
            this.deleteAction.setEnabled(canDelete);
            this.editAction.setEnabled(array.length == 1 && editModel.canEdit(array[0]));
        }
    }

    @Override
    public boolean isEdited() {
        return this.edited || !this.initialValues.equals(this.currentValues);
    }

    @Override
    public List<V> getValue() {
        return this.currentValues;
    }

    @Override
    public Control getControl() {
        return this.getTableViewer().getControl();
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }
}

