/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.workbench;

import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

@Creatable
public class PerspectiveSupport {
    @Inject
    private EModelService eModelService;
    @Inject
    private EPartService ePartService;
    @Inject
    private MApplication mApplication;
    @Inject
    private IEventBroker eventBroker;

    public String getActivePerspectiveId() {
        MPerspective perspective = this.getActiveMPerspective();
        if (perspective != null) {
            return perspective.getElementId();
        }
        return "";
    }

    public String getActivePerspective() {
        MPerspective perspective = this.getActiveMPerspective();
        if (perspective != null) {
            String perspectiveName = perspective.getLabel();
            perspectiveName = perspectiveName.replaceAll("<", "");
            perspectiveName = perspectiveName.replaceAll(">", "");
            return perspectiveName;
        }
        return "";
    }

    private MPerspective getActiveMPerspective() {
        List perspectiveStacks = this.eModelService.findElements((MUIElement)this.mApplication, null, MPerspectiveStack.class, null);
        if (perspectiveStacks.size() > 0) {
            MPerspectiveStack perspectiveStack = (MPerspectiveStack)perspectiveStacks.get(0);
            return (MPerspective)perspectiveStack.getSelectedElement();
        }
        return null;
    }

    public void changePerspective(String perspectiveId) {
        MPerspective perspectiveModel = this.getPerspectiveModel(perspectiveId);
        if (perspectiveModel != null) {
            MPerspective activePerspective = this.getActiveMPerspective();
            if (perspectiveModel.equals(activePerspective)) {
                return;
            }
            this.ePartService.switchPerspective(perspectiveModel);
            this.eventBroker.post("application/select/perspective", (Object)perspectiveModel.getLabel());
        }
    }

    public MPerspective getPerspectiveModel(String perspectiveId) {
        List elements;
        if (perspectiveId != null && (elements = this.eModelService.findElements((MUIElement)this.mApplication, null, MPerspective.class, null)) != null && !elements.isEmpty()) {
            for (MPerspective perspective : elements) {
                String elementId = perspective.getElementId();
                String elementLabel = perspective.getLabel();
                if (!perspectiveId.equals(elementId) && !elementId.equals(String.valueOf(perspectiveId) + "." + elementLabel)) continue;
                return perspective;
            }
        }
        return null;
    }
}

