/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.wsd.peak.detector.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.chemclipse.chromatogram.peak.detector.core.IPeakDetectorSupplier;
import org.eclipse.chemclipse.chromatogram.peak.detector.exceptions.NoPeakDetectorAvailableException;
import org.eclipse.chemclipse.chromatogram.wsd.peak.detector.core.IPeakDetectorWSDSupport;
import org.eclipse.chemclipse.chromatogram.wsd.peak.detector.core.PeakDetectorWSD;
import org.eclipse.chemclipse.chromatogram.wsd.peak.detector.settings.IPeakDetectorSettingsWSD;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.ChromatogramSelectionProcessorSupplier;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IProcessTypeSupplier.class})
public class PeakDetectorWSDProcessTypeSupplier
implements IProcessTypeSupplier {
    public String getCategory() {
        return "Peak Detector";
    }

    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        try {
            IPeakDetectorWSDSupport support = PeakDetectorWSD.getPeakDetectorSupport();
            ArrayList list = new ArrayList();
            for (String processorId : support.getAvailablePeakDetectorIds()) {
                IPeakDetectorSupplier supplier = support.getPeakDetectorSupplier(processorId);
                list.add((IProcessSupplier<?>)new PeakDetectorProcessorSupplier(supplier, this));
            }
            return list;
        }
        catch (NoPeakDetectorAvailableException e) {
            return Collections.emptyList();
        }
    }

    private static final class PeakDetectorProcessorSupplier
    extends ChromatogramSelectionProcessorSupplier<IPeakDetectorSettingsWSD> {
        private final IPeakDetectorSupplier supplier;

        public PeakDetectorProcessorSupplier(IPeakDetectorSupplier supplier, IProcessTypeSupplier parent) {
            super("PeakDetectorWSD." + supplier.getId(), supplier.getPeakDetectorName(), supplier.getDescription(), supplier.getSettingsClass(), parent, new DataType[]{DataType.WSD});
            this.supplier = supplier;
        }

        public IChromatogramSelection<?, ?> apply(IChromatogramSelection<?, ?> chromatogramSelection, IPeakDetectorSettingsWSD processSettings, MessageConsumer messageConsumer, IProgressMonitor monitor) {
            if (chromatogramSelection instanceof IChromatogramSelectionWSD) {
                IChromatogramSelectionWSD chromatogramSelectionCSD = (IChromatogramSelectionWSD)chromatogramSelection;
                if (processSettings instanceof IPeakDetectorSettingsWSD) {
                    messageConsumer.addMessages((MessageProvider)PeakDetectorWSD.detect(chromatogramSelectionCSD, processSettings, this.supplier.getId(), monitor));
                } else {
                    messageConsumer.addMessages((MessageProvider)PeakDetectorWSD.detect(chromatogramSelectionCSD, this.supplier.getId(), monitor));
                }
            } else {
                messageConsumer.addWarnMessage(this.getDescription(), "Only WSD Chromatogram supported, skipp processing");
            }
            return chromatogramSelection;
        }

        public boolean matchesId(String id) {
            return super.matchesId(id) || this.supplier.getId().equals(id);
        }
    }
}

