/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.ui.modifier;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.chromatogram.ChromatogramFilterMSD;
import org.eclipse.chemclipse.model.processor.AbstractChromatogramProcessor;
import org.eclipse.chemclipse.model.processor.IChromatogramProcessor;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class FilterModifierChromatogram
extends AbstractChromatogramProcessor
implements IRunnableWithProgress {
    private static final String DESCRIPTION = "Subtract Filter Chromatogram";

    public FilterModifierChromatogram(IChromatogramSelectionMSD chromatogramSelection) {
        super((IChromatogramSelection)chromatogramSelection);
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public void execute(IProgressMonitor monitor) {
        if (this.getChromatogramSelection() instanceof IChromatogramSelectionMSD) {
            IChromatogramSelectionMSD chromatogramSelection = (IChromatogramSelectionMSD)this.getChromatogramSelection();
            IProcessingInfo processingInfo = ChromatogramFilterMSD.applyFilter((IChromatogramSelectionMSD)chromatogramSelection, (String)"org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.chromatogram", (IProgressMonitor)monitor);
            ProcessingInfoViewSupport.updateProcessingInfo((MessageProvider)processingInfo, (boolean)false);
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(DESCRIPTION, -1);
            this.getChromatogramSelection().getChromatogram().doOperation((IChromatogramProcessor)this, monitor);
            this.updateSelection();
        }
        finally {
            monitor.done();
        }
    }

    private void updateSelection() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                FilterModifierChromatogram.this.getChromatogramSelection().update(true);
            }
        });
    }
}

