/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.ui.preferences;

import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.settings.IOnsiteSettings;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.ui.Activator;
import org.eclipse.chemclipse.support.settings.OperatingSystemUtils;
import org.eclipse.chemclipse.support.ui.preferences.fieldeditors.FloatFieldEditor;
import org.eclipse.chemclipse.support.ui.preferences.fieldeditors.LabelFieldEditor;
import org.eclipse.chemclipse.support.ui.preferences.fieldeditors.SpacerFieldEditor;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor autodetectLowMZ;
    private IntegerFieldEditor startMZ;
    private BooleanFieldEditor autodetectHighMZ;
    private IntegerFieldEditor stopMZ;
    private BooleanFieldEditor omitMZ;
    private StringFieldEditor omitedMZ;
    private BooleanFieldEditor useSolventTailing;
    private IntegerFieldEditor solventTailingMZ;
    private BooleanFieldEditor useColumnBleed;
    private IntegerFieldEditor columnBleedMZ;

    public PreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("AMDIS Peak Detector");
    }

    public void createFieldEditors() {
        this.addField((FieldEditor)new SpacerFieldEditor(this.getFieldEditorParent()));
        this.addField((FieldEditor)new LabelFieldEditor("AMDIS application (AMDIS32$.EXE).", this.getFieldEditorParent()));
        this.addField((FieldEditor)new FileFieldEditor("amdisApplication", "AMDIS32$.EXE", this.getFieldEditorParent()));
        this.addField((FieldEditor)new DirectoryFieldEditor("amdisTmpPath", "Tmp Path", this.getFieldEditorParent()));
        if (OperatingSystemUtils.isMac()) {
            this.addField((FieldEditor)new StringFieldEditor("macWineBinary", "Wine binary (/Applications/Wine.app)", this.getFieldEditorParent()));
        }
        this.addField((FieldEditor)new SpacerFieldEditor(this.getFieldEditorParent()));
        this.addField((FieldEditor)new LabelFieldEditor("AMDIS settings.", this.getFieldEditorParent()));
        this.autodetectLowMZ = new BooleanFieldEditor("lowMzAuto", "Autodetect low m/z:", this.getFieldEditorParent());
        this.addField((FieldEditor)this.autodetectLowMZ);
        this.startMZ = new IntegerFieldEditor("startMz", "m/z:", this.getFieldEditorParent());
        this.addField((FieldEditor)this.startMZ);
        this.autodetectHighMZ = new BooleanFieldEditor("highMzAuto", "Autodetect high m/z:", this.getFieldEditorParent());
        this.addField((FieldEditor)this.autodetectHighMZ);
        this.stopMZ = new IntegerFieldEditor("stopMz", "m/z:", this.getFieldEditorParent());
        this.addField((FieldEditor)this.stopMZ);
        this.omitMZ = new BooleanFieldEditor("omitMz", "Omit m/z:", this.getFieldEditorParent());
        this.addField((FieldEditor)this.omitMZ);
        this.omitedMZ = new StringFieldEditor("omitedMz", "Up to 8 m/z values separated by a space, 0 to omit TIC:", this.getFieldEditorParent());
        this.addField((FieldEditor)this.omitedMZ);
        this.useSolventTailing = new BooleanFieldEditor("useSolventTailing", "Use solvent tailing:", this.getFieldEditorParent());
        this.addField((FieldEditor)this.useSolventTailing);
        this.solventTailingMZ = new IntegerFieldEditor("solventTailingMz", "Solvent tailing m/z:", this.getFieldEditorParent());
        this.addField((FieldEditor)this.solventTailingMZ);
        this.useColumnBleed = new BooleanFieldEditor("useColumnBleed", "Use column bleed:", this.getFieldEditorParent());
        this.addField((FieldEditor)this.useColumnBleed);
        this.columnBleedMZ = new IntegerFieldEditor("columnBleedMz", "Column bleed m/z:", this.getFieldEditorParent());
        this.addField((FieldEditor)this.columnBleedMZ);
        this.addField((FieldEditor)new SpacerFieldEditor(this.getFieldEditorParent()));
        IntegerFieldEditor peakWidthFieldEditor = new IntegerFieldEditor("peakWidth", "Peak width:", this.getFieldEditorParent());
        peakWidthFieldEditor.setValidRange(12, 32);
        this.addField((FieldEditor)peakWidthFieldEditor);
        this.addField((FieldEditor)new SpacerFieldEditor(this.getFieldEditorParent()));
        this.addField((FieldEditor)new ComboFieldEditor("threshold", "Threshold:", IOnsiteSettings.THRESHOLD_VALUES, this.getFieldEditorParent()));
        this.addField((FieldEditor)new ComboFieldEditor("adjacentPeakSubtraction", "Adjacent Peak Subtraction:", IOnsiteSettings.ADJACENT_PEAK_SUBTRACTION_VALUES, this.getFieldEditorParent()));
        this.addField((FieldEditor)new ComboFieldEditor("resolution", "Resolution:", IOnsiteSettings.RESOLUTION_VALUES, this.getFieldEditorParent()));
        this.addField((FieldEditor)new ComboFieldEditor("sensitivity", "Sensitivity:", IOnsiteSettings.SENSITIVITY_VALUES, this.getFieldEditorParent()));
        this.addField((FieldEditor)new ComboFieldEditor("shapeRequirements", "Shape Requirements:", IOnsiteSettings.SHAPE_REQUIREMENTS_VALUES, this.getFieldEditorParent()));
        this.addField((FieldEditor)new SpacerFieldEditor(this.getFieldEditorParent()));
        this.addField((FieldEditor)new LabelFieldEditor("Extra settings (to improve the result quality).", this.getFieldEditorParent()));
        this.addField((FieldEditor)new FloatFieldEditor("minSignalToNoiseRatio", "Minimum S/N ratio (0 = add all peaks):", 0.0f, Float.MAX_VALUE, this.getFieldEditorParent()));
        this.addField((FieldEditor)new FloatFieldEditor("minLeading", "Min Leading:", 0.0f, Float.MAX_VALUE, this.getFieldEditorParent()));
        this.addField((FieldEditor)new FloatFieldEditor("maxLeading", "Max Leading:", 0.0f, Float.MAX_VALUE, this.getFieldEditorParent()));
        this.addField((FieldEditor)new FloatFieldEditor("minTailing", "Min Tailing:", 0.0f, Float.MAX_VALUE, this.getFieldEditorParent()));
        this.addField((FieldEditor)new FloatFieldEditor("maxTailing", "Max Tailing:", 0.0f, Float.MAX_VALUE, this.getFieldEditorParent()));
        Control[] controlArray = this.getFieldEditorParent().getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    PreferencePage.this.enableDisableFieldEditors(false);
                }
            });
            ++n2;
        }
        this.enableDisableFieldEditors(true);
    }

    public void init(IWorkbench workbench) {
    }

    private void enableDisableFieldEditors(boolean loadInitially) {
        boolean isUseColumnBleed;
        boolean isUseSolventTailing;
        boolean isOmitMZ;
        boolean isAutodetectHighMZ;
        boolean isAutodetectLowMZ;
        if (loadInitially) {
            IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
            isAutodetectLowMZ = preferenceStore.getBoolean("lowMzAuto");
            isAutodetectHighMZ = preferenceStore.getBoolean("highMzAuto");
            isOmitMZ = preferenceStore.getBoolean("omitMz");
            isUseSolventTailing = preferenceStore.getBoolean("useSolventTailing");
            isUseColumnBleed = preferenceStore.getBoolean("useColumnBleed");
        } else {
            isAutodetectLowMZ = this.autodetectLowMZ.getBooleanValue();
            isAutodetectHighMZ = this.autodetectHighMZ.getBooleanValue();
            isOmitMZ = this.omitMZ.getBooleanValue();
            isUseSolventTailing = this.useSolventTailing.getBooleanValue();
            isUseColumnBleed = this.useColumnBleed.getBooleanValue();
        }
        this.startMZ.setEnabled(!isAutodetectLowMZ, this.getFieldEditorParent());
        this.stopMZ.setEnabled(!isAutodetectHighMZ, this.getFieldEditorParent());
        this.omitedMZ.setEnabled(isOmitMZ, this.getFieldEditorParent());
        this.solventTailingMZ.setEnabled(isUseSolventTailing, this.getFieldEditorParent());
        this.columnBleedMZ.setEnabled(isUseColumnBleed, this.getFieldEditorParent());
    }
}

