/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.sumarea.internal.core;

import org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.sumarea.internal.core.AbstractSumareaIntegrator;
import org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.sumarea.internal.core.ISumareaIntegrator;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.support.IRetentionTimeRange;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.xic.ExtractedIonSignalExtractor;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignals;

public class BackgroundIntegrator
extends AbstractSumareaIntegrator
implements ISumareaIntegrator {
    private static final Logger logger = Logger.getLogger(BackgroundIntegrator.class);

    @Override
    public double integrate(IChromatogramSelectionMSD chromatogramSelection) {
        return this.integrate(chromatogramSelection, 0);
    }

    @Override
    public double integrate(IChromatogramSelectionMSD chromatogramSelection, int ion) {
        double backgroundArea = 0.0;
        IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
        int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        IBaselineModel baselineModel = chromatogram.getBaselineModel();
        try {
            ExtractedIonSignalExtractor extractedIonSignalExtractor = new ExtractedIonSignalExtractor(chromatogram);
            IExtractedIonSignals extractedIonSignals = extractedIonSignalExtractor.getExtractedIonSignals((IRetentionTimeRange)chromatogramSelection);
            double ionPercentage = 0.0;
            double segmentArea = 0.0;
            int scan = startScan;
            while (scan < stopScan) {
                try {
                    IExtractedIonSignal startSignal = extractedIonSignals.getExtractedIonSignal(scan);
                    IExtractedIonSignal stopSignal = extractedIonSignals.getExtractedIonSignal(scan + 1);
                    IVendorMassSpectrum supplierMassSpectrumStart = chromatogram.getSupplierScan(scan);
                    IVendorMassSpectrum supplierMassSpectrumStop = chromatogram.getSupplierScan(scan + 1);
                    ionPercentage = this.calculateIonPercentageOfScans(supplierMassSpectrumStart, supplierMassSpectrumStop, ion);
                    if (startSignal != null && stopSignal != null) {
                        int start = startSignal.getRetentionTime();
                        int stop = stopSignal.getRetentionTime();
                        float startAbundance = baselineModel.getBackgroundAbundance(start);
                        float stopAbundance = baselineModel.getBackgroundAbundance(stop);
                        segmentArea = this.calculateArea(start, stop, startAbundance, stopAbundance);
                        backgroundArea += segmentArea * ionPercentage;
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)e);
                }
                ++scan;
            }
        }
        catch (ChromatogramIsNullException e1) {
            logger.warn((Object)e1);
        }
        return backgroundArea;
    }

    private double calculateIonPercentageOfScans(IVendorMassSpectrum supplierMassSpectrumStart, IVendorMassSpectrum supplierMassSpectrumStop, int ion) {
        IExtractedIonSignal extractedIonSignalStart = supplierMassSpectrumStart.getExtractedIonSignal();
        IExtractedIonSignal extractedIonSignalStop = supplierMassSpectrumStop.getExtractedIonSignal();
        double percentageStartSignal = 0.0;
        float startSignal = extractedIonSignalStart.getTotalSignal();
        if (startSignal > 0.0f) {
            percentageStartSignal = 100.0 / (double)startSignal * (double)extractedIonSignalStart.getAbundance(ion);
        }
        double percentageStopSignal = 0.0;
        float stopSignal = extractedIonSignalStop.getTotalSignal();
        if (stopSignal > 0.0f) {
            percentageStopSignal = 100.0 / (double)stopSignal * (double)extractedIonSignalStop.getAbundance(ion);
        }
        return (percentageStartSignal + percentageStopSignal) / 2.0 / 100.0;
    }
}

