/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.model.xwc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.xwc.IExtractedSingleWavelengthSignal;
import org.eclipse.chemclipse.wsd.model.xwc.IExtractedSingleWavelengthSignals;

public class ExtractedSingleWavelengthSignals
implements IExtractedSingleWavelengthSignals {
    private static final Logger logger = Logger.getLogger(ExtractedSingleWavelengthSignals.class);
    private List<IExtractedSingleWavelengthSignal> signals;
    private int startScan = 0;
    private int stopScan = 0;
    private IChromatogramWSD chromatogram = null;
    private double wavelength;

    public ExtractedSingleWavelengthSignals(int numberOfScans, double wavelength, IChromatogramWSD chromatogram) {
        if (numberOfScans <= 0) {
            numberOfScans = 0;
            this.startScan = 0;
            this.stopScan = 0;
        } else {
            this.startScan = 1;
            this.stopScan = numberOfScans;
        }
        this.signals = new ArrayList<IExtractedSingleWavelengthSignal>(numberOfScans);
        this.wavelength = wavelength;
        this.chromatogram = chromatogram;
    }

    public ExtractedSingleWavelengthSignals(int startScan, int stopScan, double wavelength, IChromatogramWSD chromatogram) {
        int numberOfScans;
        startScan = startScan <= 0 ? 0 : startScan;
        stopScan = stopScan <= 0 ? 0 : stopScan;
        int start = Math.min(startScan, stopScan);
        int stop = Math.max(startScan, stopScan);
        if (start == 0 || stop == 0) {
            numberOfScans = 0;
            start = 0;
            stop = 0;
        } else {
            numberOfScans = stop - start + 1;
        }
        this.signals = new ArrayList<IExtractedSingleWavelengthSignal>(numberOfScans);
        this.startScan = start;
        this.stopScan = stop;
        this.wavelength = wavelength;
        this.chromatogram = chromatogram;
    }

    @Override
    public IChromatogramWSD getChromatogram() {
        return this.chromatogram;
    }

    @Override
    public void add(IExtractedSingleWavelengthSignal extractedWavelengthSignal) {
        this.signals.add(extractedWavelengthSignal);
    }

    @Override
    public IExtractedSingleWavelengthSignal getTotalScanSignal(int scan) {
        if (scan <= 0) {
            return null;
        }
        if (scan < this.startScan || scan > this.stopScan) {
            return null;
        }
        int correction = this.startScan - 1;
        scan -= correction;
        return this.signals.get(--scan);
    }

    public int size() {
        return this.signals.size();
    }

    public int getStartScan() {
        return this.startScan;
    }

    public int getStopScan() {
        return this.stopScan;
    }

    @Override
    public IExtractedSingleWavelengthSignals makeDeepCopy() {
        ExtractedSingleWavelengthSignals extractedWavelengthSignals = new ExtractedSingleWavelengthSignals(this.startScan, this.stopScan, this.wavelength, this.chromatogram);
        for (ITotalScanSignal iTotalScanSignal : this.signals) {
            extractedWavelengthSignals.add(iTotalScanSignal.makeDeepCopy());
        }
        return extractedWavelengthSignals;
    }

    @Override
    public double getWavelength() {
        return this.wavelength;
    }

    public void add(ITotalScanSignal totalScanSignal) {
        if (totalScanSignal instanceof IExtractedSingleWavelengthSignal) {
            this.add((IExtractedSingleWavelengthSignal)totalScanSignal);
        }
    }

    public List<ITotalScanSignal> getTotalScanSignals() {
        return new ArrayList<ITotalScanSignal>(this.signals);
    }

    public List<ITotalScanSignal> getTotalScanSignalList() {
        return Collections.unmodifiableList(this.signals);
    }

    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private int startScan;
            private int stopScan;
            private int actualScan;
            {
                this.startScan = ExtractedSingleWavelengthSignals.this.getStartScan();
                this.stopScan = ExtractedSingleWavelengthSignals.this.getStopScan();
                this.actualScan = ExtractedSingleWavelengthSignals.this.getStartScan();
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.actualScan++;
            }

            @Override
            public boolean hasNext() {
                if (this.startScan == 0 || this.stopScan == 0) {
                    return false;
                }
                return this.actualScan <= this.stopScan;
            }
        };
    }
}

