/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.model.xwc;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignal;
import org.eclipse.chemclipse.model.signals.TotalScanSignals;
import org.eclipse.chemclipse.model.support.IScanRange;
import org.eclipse.chemclipse.model.support.ScanRange;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.IScanWSD;
import org.eclipse.chemclipse.wsd.model.core.exceptions.NoExtractedWavelengthSignalStoredException;
import org.eclipse.chemclipse.wsd.model.core.implementation.ScanSignalWSD;
import org.eclipse.chemclipse.wsd.model.core.implementation.ScanWSD;
import org.eclipse.chemclipse.wsd.model.xwc.ExtractedWavelengthSignal;
import org.eclipse.chemclipse.wsd.model.xwc.IExtractedWavelengthSignal;
import org.eclipse.chemclipse.wsd.model.xwc.IExtractedWavelengthSignals;

public class ExtractedWavelengthSignals
implements IExtractedWavelengthSignals {
    private static final Logger logger = Logger.getLogger(ExtractedWavelengthSignals.class);
    private List<IExtractedWavelengthSignal> signals;
    private int startWavelength = Integer.MAX_VALUE;
    private int stopWavelength = 0;
    private int startScan = 0;
    private int stopScan = 0;
    private IChromatogramWSD chromatogram = null;

    public ExtractedWavelengthSignals(int numberOfScans) {
        if (numberOfScans <= 0) {
            numberOfScans = 0;
            this.startScan = 0;
            this.stopScan = 0;
        } else {
            this.startScan = 1;
            this.stopScan = numberOfScans;
        }
        this.signals = new ArrayList<IExtractedWavelengthSignal>(numberOfScans);
    }

    public ExtractedWavelengthSignals(int numberOfScans, IChromatogramWSD chromatogram) {
        this(numberOfScans);
        this.chromatogram = chromatogram;
    }

    public ExtractedWavelengthSignals(int startScan, int stopScan) {
        int numberOfScans;
        startScan = startScan <= 0 ? 0 : startScan;
        stopScan = stopScan <= 0 ? 0 : stopScan;
        int start = Math.min(startScan, stopScan);
        int stop = Math.max(startScan, stopScan);
        if (start == 0 || stop == 0) {
            numberOfScans = 0;
            start = 0;
            stop = 0;
        } else {
            numberOfScans = stop - start + 1;
        }
        this.signals = new ArrayList<IExtractedWavelengthSignal>(numberOfScans);
        this.startScan = start;
        this.stopScan = stop;
    }

    public ExtractedWavelengthSignals(int startScan, int stopScan, IChromatogramWSD chromatogram) {
        this(startScan, stopScan);
        this.chromatogram = chromatogram;
    }

    @Override
    public IChromatogramWSD getChromatogram() {
        return this.chromatogram;
    }

    @Override
    public void add(IExtractedWavelengthSignal extractedWavelengthSignal) {
        this.signals.add(extractedWavelengthSignal);
        this.setStartWavelength(extractedWavelengthSignal.getStartWavelength());
        this.setStopWavelength(extractedWavelengthSignal.getStopWavelength());
    }

    @Override
    public void add(int wavlength, float abundance, int retentionTime, boolean removePreviousAbundance) {
        try {
            int scan = this.findClosestScan(retentionTime);
            if (scan > 0) {
                IExtractedWavelengthSignal extractedWavelengthSignal = this.getExtractedWavelengthSignal(scan);
                extractedWavelengthSignal.setAbundance(wavlength, abundance, removePreviousAbundance);
            }
        }
        catch (ChromatogramIsNullException e) {
            logger.warn((Object)e);
        }
        catch (NoExtractedWavelengthSignalStoredException e) {
            logger.warn((Object)e);
        }
    }

    @Override
    public IExtractedWavelengthSignal getExtractedWavelengthSignal(int scan) throws NoExtractedWavelengthSignalStoredException {
        if (scan <= 0) {
            throw new NoExtractedWavelengthSignalStoredException("The requested scan: " + scan + " is not available.");
        }
        if (scan < this.startScan || scan > this.stopScan) {
            throw new NoExtractedWavelengthSignalStoredException("The requested scan: " + scan + " is not available.");
        }
        int correction = this.startScan - 1;
        scan -= correction;
        return this.signals.get(--scan);
    }

    @Override
    public List<IExtractedWavelengthSignal> getExtractedWavelengthSignals() {
        return this.signals;
    }

    @Override
    public IScanWSD getScan(int scan) {
        IExtractedWavelengthSignal extractedWavelengthSignal;
        try {
            extractedWavelengthSignal = this.getExtractedWavelengthSignal(scan);
        }
        catch (NoExtractedWavelengthSignalStoredException e) {
            logger.warn((Object)e);
            return null;
        }
        ScanWSD scanWSD = new ScanWSD();
        scanWSD.setParentChromatogram(this.getChromatogram());
        int startWavelength = extractedWavelengthSignal.getStartWavelength();
        int stopWavelength = extractedWavelengthSignal.getStopWavelength();
        int wavelength = startWavelength;
        while (wavelength <= stopWavelength) {
            float abundance = extractedWavelengthSignal.getAbundance(wavelength);
            if (abundance > 0.0f) {
                ScanSignalWSD scanSignalWSD = new ScanSignalWSD(wavelength, abundance);
                scanWSD.addScanSignal(scanSignalWSD);
            }
            ++wavelength;
        }
        return scanWSD;
    }

    @Override
    public int getStartWavelength() {
        return this.startWavelength;
    }

    @Override
    public int getStopWavelength() {
        return this.stopWavelength;
    }

    @Override
    public int size() {
        return this.signals.size();
    }

    @Override
    public int getStartScan() {
        return this.startScan;
    }

    @Override
    public int getStopScan() {
        return this.stopScan;
    }

    @Override
    public ITotalScanSignals getTotalWavelengthSignals(int wavelength) {
        ScanRange scanRange = new ScanRange(this.getStartScan(), this.getStopScan());
        return this.getTotalWavelengthSignals(wavelength, (IScanRange)scanRange);
    }

    @Override
    public ITotalScanSignals getTotalWavelengthSignals() {
        ScanRange scanRange = new ScanRange(this.getStartScan(), this.getStopScan());
        return this.getTotalWavelengthSignals(0, (IScanRange)scanRange);
    }

    @Override
    public ITotalScanSignals getTotalWavelengthSignals(IScanRange scanRange) {
        return this.getTotalWavelengthSignals(0, scanRange);
    }

    @Override
    public ITotalScanSignals getTotalWavelengthSignals(int wavelength, IScanRange scanRange) {
        int stopScan;
        int startScan;
        if (scanRange != null) {
            startScan = scanRange.getStartScan();
            stopScan = scanRange.getStopScan();
        } else {
            startScan = 0;
            stopScan = 0;
        }
        TotalScanSignals totalIonSignals = new TotalScanSignals(startScan, stopScan, (IChromatogram)this.getChromatogram());
        int scan = startScan;
        while (scan <= stopScan) {
            try {
                IExtractedWavelengthSignal extractedWavelengthSignal = this.getExtractedWavelengthSignal(scan);
                int retentionTime = extractedWavelengthSignal.getRetentionTime();
                float retentionIndex = extractedWavelengthSignal.getRetentionIndex();
                float signal = wavelength == 0 ? extractedWavelengthSignal.getTotalSignal() : extractedWavelengthSignal.getAbundance(wavelength);
                TotalScanSignal totalWavelengthSignal = new TotalScanSignal(retentionTime, retentionIndex, signal);
                totalIonSignals.add((ITotalScanSignal)totalWavelengthSignal);
            }
            catch (NoExtractedWavelengthSignalStoredException e) {
                logger.warn((Object)e);
            }
            ++scan;
        }
        return totalIonSignals;
    }

    @Override
    public IExtractedWavelengthSignals makeDeepCopyWithoutSignals() {
        ExtractedWavelengthSignals extractedWavelengthSignals = new ExtractedWavelengthSignals(this.startScan, this.stopScan, this.chromatogram);
        for (IExtractedWavelengthSignal signal : this.signals) {
            ExtractedWavelengthSignal extractedWavelengthSignal = new ExtractedWavelengthSignal(signal.getStartWavelength(), signal.getStopWavelength());
            extractedWavelengthSignal.setRetentionTime(signal.getRetentionTime());
            extractedWavelengthSignal.setRetentionIndex(signal.getRetentionIndex());
            extractedWavelengthSignals.add(extractedWavelengthSignal);
        }
        return extractedWavelengthSignals;
    }

    private void setStartWavelength(int wavelength) {
        if (wavelength < this.startWavelength) {
            this.startWavelength = wavelength;
        }
    }

    private void setStopWavelength(int wavelength) {
        if (wavelength > this.stopWavelength) {
            this.stopWavelength = wavelength;
        }
    }

    @Override
    public Set<Integer> getUsedWavelenghts() {
        TreeSet<Integer> usedWavelenghts = new TreeSet<Integer>();
        for (IExtractedWavelengthSignal signal : this.signals) {
            int wavelength = signal.getStartWavelength();
            while (wavelength <= signal.getStopWavelength()) {
                if (signal.getAbundance(wavelength) != 0.0f) {
                    usedWavelenghts.add(wavelength);
                }
                ++wavelength;
            }
        }
        return usedWavelenghts;
    }

    private int findClosestScan(int retentionTime) throws ChromatogramIsNullException {
        if (this.chromatogram == null) {
            throw new ChromatogramIsNullException();
        }
        return this.chromatogram.getScanNumber(retentionTime);
    }
}

