/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.quantitation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.model.quantitation.IResponseSignal;
import org.eclipse.chemclipse.model.quantitation.IResponseSignals;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.core.Point;
import org.eclipse.chemclipse.numeric.equations.Equations;
import org.eclipse.chemclipse.numeric.equations.LinearEquation;
import org.eclipse.chemclipse.numeric.equations.QuadraticEquation;

public class ResponseSignals
extends ArrayList<IResponseSignal>
implements IResponseSignals {
    private static final long serialVersionUID = 7626025302880914344L;

    @Override
    public LinearEquation getLinearEquation(double signal, boolean isCrossZero) {
        List<IPoint> points = this.getPoints(signal, isCrossZero);
        IPoint[] pointArray = points.toArray(new IPoint[points.size()]);
        LinearEquation linearEquation = Equations.createLinearEquation((IPoint[])pointArray);
        return linearEquation;
    }

    @Override
    public QuadraticEquation getQuadraticEquation(double signal, boolean isCrossZero) {
        List<IPoint> points = this.getPoints(signal, isCrossZero);
        IPoint[] pointArray = points.toArray(new IPoint[points.size()]);
        QuadraticEquation quadraticEquation = Equations.createQuadraticEquation((IPoint[])pointArray);
        return quadraticEquation;
    }

    @Override
    public double getAverageFactor(double signal, boolean isCrossZero) {
        double x = 0.0;
        double y = 0.0;
        List<IPoint> points = this.getPoints(signal, isCrossZero);
        int size = points.size();
        if (size == 0) {
            return 0.0;
        }
        for (IPoint point : points) {
            x += point.getX();
            y += point.getY();
        }
        x /= (double)size;
        if ((y /= (double)size) == 0.0) {
            return 0.0;
        }
        return x / y;
    }

    @Override
    public double getMinResponseValue(double signal) {
        double minResponse = Double.MAX_VALUE;
        for (IResponseSignal entry : this) {
            double response;
            if (signal != entry.getSignal() || !((response = entry.getResponse()) < minResponse)) continue;
            minResponse = response;
        }
        return minResponse == Double.MAX_VALUE ? 0.0 : minResponse;
    }

    @Override
    public double getMaxResponseValue(double signal) {
        double maxResponse = 0.0;
        for (IResponseSignal entry : this) {
            double response;
            if (signal != entry.getSignal() || !((response = entry.getResponse()) > maxResponse)) continue;
            maxResponse = response;
        }
        return maxResponse;
    }

    @Override
    public double getMinResponseValue() {
        double minResponse = Double.MAX_VALUE;
        for (IResponseSignal entry : this) {
            double response = entry.getResponse();
            if (!(response < minResponse)) continue;
            minResponse = response;
        }
        return minResponse == Double.MAX_VALUE ? 0.0 : minResponse;
    }

    @Override
    public double getMaxResponseValue() {
        double maxResponse = 0.0;
        for (IResponseSignal entry : this) {
            double response = entry.getResponse();
            if (!(response > maxResponse)) continue;
            maxResponse = response;
        }
        return maxResponse;
    }

    @Override
    public Set<Double> getSignalSet() {
        HashSet<Double> signalSet = new HashSet<Double>();
        for (IResponseSignal entry : this) {
            signalSet.add(entry.getSignal());
        }
        return signalSet;
    }

    @Override
    public List<IResponseSignal> getList(double signal) {
        ArrayList<IResponseSignal> entries = new ArrayList<IResponseSignal>();
        for (IResponseSignal entry : this) {
            if (entry.getSignal() != signal) continue;
            entries.add(entry);
        }
        return entries;
    }

    private List<IPoint> getPoints(double signal, boolean isCrossZero) {
        ArrayList<IPoint> points = new ArrayList<IPoint>();
        if (isCrossZero) {
            points.add((IPoint)new Point(0.0, 0.0));
        }
        for (IResponseSignal entry : this) {
            if (signal != entry.getSignal()) continue;
            points.add((IPoint)new Point(entry.getConcentration(), entry.getResponse()));
        }
        return points;
    }
}

