/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.savitzkygolay.ui.handlers;

import java.lang.reflect.InvocationTargetException;
import javax.inject.Named;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.savitzkygolay.ui.internal.handlers.MassSpectrumFilterRunnable;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.progress.core.InfoType;
import org.eclipse.chemclipse.progress.core.StatusLineLogger;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class FilterHandlerMassSpectrum
implements EventHandler {
    private static final Logger logger = Logger.getLogger(FilterHandlerMassSpectrum.class);
    private static IScanMSD massSpectrum;

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part) {
        if (massSpectrum != null) {
            Display display = Display.getCurrent();
            StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Start Savitzky-Golay Filter");
            MassSpectrumFilterRunnable runnable = new MassSpectrumFilterRunnable(massSpectrum);
            ProgressMonitorDialog monitor = new ProgressMonitorDialog(display.getActiveShell());
            try {
                monitor.run(true, true, (IRunnableWithProgress)runnable);
            }
            catch (InvocationTargetException e) {
                logger.warn((Object)e);
            }
            catch (InterruptedException e) {
                logger.warn((Object)e);
            }
            StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Done: Savitzky-Golay Filter applied");
        }
    }

    public void handleEvent(Event event) {
        massSpectrum = event.getTopic().equals("scan/msd/update/selection") ? (IScanMSD)event.getProperty("org.eclipse.e4.data") : null;
    }
}

